/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.parser.JSPWikiMarkupParser;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.tags.ParamHandler;
import com.ecyrd.jspwiki.tags.WikiLinkTag;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class LinkTag
extends WikiLinkTag
implements ParamHandler,
BodyTag {
    static final long serialVersionUID = 0L;
    private String m_version = null;
    private String m_class = null;
    private String m_style = null;
    private String m_title = null;
    private String m_target = null;
    private String m_compareToVersion = null;
    private String m_rel = null;
    private String m_jsp = null;
    private String m_ref = null;
    private String m_context = WikiContext.VIEW;
    private String m_accesskey = null;
    private String m_templatefile = null;
    private boolean m_absolute = false;
    private boolean m_overrideAbsolute = false;
    private Map<String, String> m_containedParams;
    private BodyContent m_bodyContent;

    public void initTag() {
        super.initTag();
        this.m_templatefile = null;
        this.m_accesskey = null;
        this.m_ref = null;
        this.m_jsp = null;
        this.m_rel = null;
        this.m_compareToVersion = null;
        this.m_target = null;
        this.m_title = null;
        this.m_style = null;
        this.m_class = null;
        this.m_version = null;
        this.m_context = WikiContext.VIEW;
        this.m_absolute = false;
    }

    public void setTemplatefile(String key) {
        this.m_templatefile = key;
    }

    public void setAccessKey(String key) {
        this.m_accesskey = key;
    }

    public void setAbsolute(String arg) {
        this.m_overrideAbsolute = true;
        this.m_absolute = TextUtil.isPositive(arg);
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String arg) {
        this.m_version = arg;
    }

    public void setClass(String arg) {
        this.m_class = arg;
    }

    public void setStyle(String style) {
        this.m_style = style;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setCompareToVersion(String ver) {
        this.m_compareToVersion = ver;
    }

    public void setRel(String rel) {
        this.m_rel = rel;
    }

    public void setRef(String ref) {
        this.m_ref = ref;
    }

    public void setJsp(String jsp) {
        this.m_jsp = jsp;
    }

    public void setContext(String context) {
        this.m_context = context;
    }

    public void setContainedParameter(String name, String value) {
        if (name != null) {
            if (this.m_containedParams == null) {
                this.m_containedParams = new HashMap<String, String>();
            }
            this.m_containedParams.put(name, value);
        }
    }

    private String figureOutURL() throws ProviderException {
        String params;
        Object page;
        String url = null;
        WikiEngine engine = this.m_wikiContext.getEngine();
        if (this.m_pageName == null && (page = this.m_wikiContext.getPage()) != null) {
            this.m_pageName = ((WikiPage)page).getName();
        }
        if (this.m_templatefile != null) {
            params = this.addParamsForRecipient(null, this.m_containedParams);
            String template = engine.getTemplateDir();
            url = engine.getURL(WikiContext.NONE, "templates/" + template + "/" + this.m_templatefile, params, false);
        } else if (this.m_jsp != null) {
            params = this.addParamsForRecipient(null, this.m_containedParams);
            url = engine.getURL(WikiContext.NONE, this.m_jsp, params, this.m_absolute);
        } else if (this.m_ref != null) {
            if (JSPWikiMarkupParser.isExternalLink(this.m_ref)) {
                url = this.m_ref;
            } else {
                int interwikipoint = this.m_ref.indexOf(":");
                if (interwikipoint != -1) {
                    String extWiki = this.m_ref.substring(0, interwikipoint);
                    String wikiPage = this.m_ref.substring(interwikipoint + 1);
                    url = engine.getInterWikiURL(extWiki);
                    if (url != null) {
                        url = TextUtil.replaceString(url, "%s", wikiPage);
                    }
                } else if (!this.m_ref.startsWith("#") && !TextUtil.isNumber(this.m_ref)) {
                    int hashMark = -1;
                    String parms = this.m_version != null ? "version=" + this.getVersion() : null;
                    WikiPage p = engine.getPage(this.m_pageName);
                    if (p instanceof Attachment) {
                        url = this.m_wikiContext.getURL(WikiContext.ATTACH, this.m_pageName);
                    } else {
                        hashMark = this.m_ref.indexOf(35);
                        if (hashMark != -1) {
                            String namedSection = this.m_ref.substring(hashMark + 1);
                            String reallink = this.m_ref.substring(0, hashMark);
                            reallink = MarkupParser.cleanLink(reallink);
                            String sectref = "";
                            String matchedLink = engine.getFinalPageName(reallink);
                            if (matchedLink != null) {
                                sectref = "section-" + engine.encodeName(matchedLink) + "-" + namedSection;
                                sectref = "#" + sectref.replace('%', '_');
                            } else {
                                matchedLink = reallink;
                            }
                            url = this.makeBasicURL(this.m_context, matchedLink, parms, this.m_absolute) + sectref;
                        } else {
                            String reallink = MarkupParser.cleanLink(this.m_ref);
                            url = this.makeBasicURL(this.m_context, reallink, parms, this.m_absolute);
                        }
                    }
                }
            }
        } else if (this.m_pageName != null && this.m_pageName.length() > 0) {
            WikiPage p = engine.getPage(this.m_pageName);
            String parms = this.m_version != null ? "version=" + this.getVersion() : null;
            parms = this.addParamsForRecipient(parms, this.m_containedParams);
            if (p instanceof Attachment) {
                String ctx = this.m_context;
                if (this.m_context == null || this.m_context.equals(WikiContext.VIEW)) {
                    ctx = WikiContext.ATTACH;
                }
                url = engine.getURL(ctx, this.m_pageName, parms, this.m_absolute);
            } else {
                url = this.makeBasicURL(this.m_context, this.m_pageName, parms, this.m_absolute);
            }
        } else {
            page = engine.getFrontPage();
            url = this.makeBasicURL(this.m_context, (String)page, null, this.m_absolute);
        }
        return url;
    }

    private String addParamsForRecipient(String addTo, Map params) {
        if (params == null || params.size() == 0) {
            return addTo;
        }
        StringBuffer buf = new StringBuffer();
        Iterator it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String n = (String)e.getKey();
            String v = (String)e.getValue();
            buf.append(n);
            buf.append("=");
            buf.append(v);
            if (!it.hasNext()) continue;
            buf.append("&amp;");
        }
        if (addTo == null) {
            return buf.toString();
        }
        if (!addTo.endsWith("&amp;")) {
            return addTo + "&amp;" + buf.toString();
        }
        return addTo + buf.toString();
    }

    private String makeBasicURL(String context, String page, String parms, boolean absolute) {
        WikiEngine engine = this.m_wikiContext.getEngine();
        if (context.equals(WikiContext.DIFF)) {
            WikiPage latest;
            int r1 = 0;
            int r2 = 0;
            if ("latest".equals(this.getVersion())) {
                latest = engine.getPage(page, -1);
                r1 = latest.getVersion();
            } else {
                r1 = "previous".equals(this.getVersion()) ? ((r1 = this.m_wikiContext.getPage().getVersion() - 1) < 1 ? 1 : r1) : ("current".equals(this.getVersion()) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.getVersion()));
            }
            if ("latest".equals(this.m_compareToVersion)) {
                latest = engine.getPage(page, -1);
                r2 = latest.getVersion();
            } else {
                r2 = "previous".equals(this.m_compareToVersion) ? ((r2 = this.m_wikiContext.getPage().getVersion() - 1) < 1 ? 1 : r2) : ("current".equals(this.m_compareToVersion) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.m_compareToVersion));
            }
            parms = "r1=" + r1 + "&amp;r2=" + r2;
        }
        String url = engine.getURL(this.m_context, this.m_pageName, parms, this.m_absolute);
        return url;
    }

    public int doWikiStartTag() throws Exception {
        return 2;
    }

    public int doEndTag() {
        try {
            if (!this.m_overrideAbsolute) {
                WikiEngine engine = this.m_wikiContext.getEngine();
                this.m_absolute = "absolute".equals(engine.getWikiProperties().getProperty("jspwiki.referenceStyle"));
            }
            JspWriter out = this.pageContext.getOut();
            String url = this.figureOutURL();
            StringBuffer sb = new StringBuffer(20);
            sb.append(this.m_class != null ? "class=\"" + this.m_class + "\" " : "");
            sb.append(this.m_style != null ? "style=\"" + this.m_style + "\" " : "");
            sb.append(this.m_target != null ? "target=\"" + this.m_target + "\" " : "");
            sb.append(this.m_title != null ? "title=\"" + this.m_title + "\" " : "");
            sb.append(this.m_rel != null ? "rel=\"" + this.m_rel + "\" " : "");
            sb.append(this.m_accesskey != null ? "accesskey=\"" + this.m_accesskey + "\" " : "");
            switch (this.m_format) {
                case 1: {
                    out.print(url);
                    break;
                }
                default: {
                    out.print("<a " + sb.toString() + " href=\"" + url + "\">");
                }
            }
            if (this.m_bodyContent != null) {
                String linktext = this.m_bodyContent.getString().trim();
                out.write(linktext);
            }
            if (this.m_format == 0) {
                out.print("</a>");
            }
        }
        catch (Exception e) {
            log.error((Object)"Tag failed", (Throwable)e);
        }
        return 6;
    }

    public void setBodyContent(BodyContent bc) {
        this.m_bodyContent = bc;
    }

    public void doInitBody() throws JspException {
    }
}

