/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.SessionMonitor;
import com.ecyrd.jspwiki.auth.authorize.Role;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class WikiRequestWrapper
extends HttpServletRequestWrapper {
    private final WikiSession m_session;

    public WikiRequestWrapper(WikiEngine engine, HttpServletRequest request) {
        super(request);
        this.m_session = SessionMonitor.getInstance(engine).find(request.getSession());
    }

    public String getRemoteUser() {
        if (super.getRemoteUser() != null) {
            return super.getRemoteUser();
        }
        if (this.m_session.isAuthenticated()) {
            return this.m_session.getLoginPrincipal().getName();
        }
        return null;
    }

    public Principal getUserPrincipal() {
        if (super.getUserPrincipal() != null) {
            return super.getUserPrincipal();
        }
        if (this.m_session.isAuthenticated()) {
            return this.m_session.getLoginPrincipal();
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        boolean hasContainerRole = super.isUserInRole(role);
        if (hasContainerRole) {
            return true;
        }
        Principal[] principals = this.m_session.getRoles();
        for (int i = 0; i < principals.length; ++i) {
            Role principal;
            if (!(principals[i] instanceof Role) || !Role.isBuiltInRole(principal = (Role)principals[i]) || !principal.getName().equals(role)) continue;
            return true;
        }
        return false;
    }
}

