/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcacheStreamBootstrapHelpUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;

public class EhcacheStreamBootstrapCacheLoader
implements BootstrapCacheLoader {
    private static Log _log = LogFactoryUtil.getLog(EhcacheStreamBootstrapCacheLoader.class);
    private static List<Ehcache> _deferredEhcaches = new ArrayList<Ehcache>();
    private static ThreadLocal<Boolean> _skipBootstrapThreadLocal = new InitialThreadLocal(EhcacheStreamBootstrapCacheLoader.class + "._skipBootstrapThreadLocal", (Object)false);
    private static boolean _started;
    private boolean _bootstrapAsynchronously = true;

    public static void resetSkip() {
        _skipBootstrapThreadLocal.remove();
    }

    public static void setSkip() {
        _skipBootstrapThreadLocal.set(Boolean.TRUE);
    }

    public static synchronized void start() {
        if (!_started) {
            _started = true;
        }
        if (_deferredEhcaches.isEmpty()) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Loading deferred caches");
        }
        try {
            try {
                EhcacheStreamBootstrapHelpUtil.loadCachesFromCluster(_deferredEhcaches.toArray(new Ehcache[_deferredEhcaches.size()]));
            }
            catch (Exception e2) {
                throw new CacheException((Throwable)e2);
            }
        }
        finally {
            _deferredEhcaches.clear();
        }
    }

    public EhcacheStreamBootstrapCacheLoader(Properties properties) {
        if (properties != null) {
            this._bootstrapAsynchronously = GetterUtil.getBoolean((String)properties.getProperty("bootstrapAsynchronously"));
        }
    }

    public Object clone() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoad(Ehcache ehcache) {
        Class<EhcacheStreamBootstrapCacheLoader> clazz = EhcacheStreamBootstrapCacheLoader.class;
        synchronized (EhcacheStreamBootstrapCacheLoader.class) {
            if (!_started) {
                _deferredEhcaches.add(ehcache);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (_skipBootstrapThreadLocal.get().booleanValue()) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Bootstraping " + ehcache.getName()));
            }
            try {
                EhcacheStreamBootstrapHelpUtil.loadCachesFromCluster(ehcache);
            }
            catch (Exception e2) {
                throw new CacheException((Throwable)e2);
            }
            return;
        }
    }

    public boolean isAsynchronous() {
        return this._bootstrapAsynchronously;
    }

    public void load(Ehcache ehcache) {
        if (this._bootstrapAsynchronously) {
            EhcacheStreamClientThread streamBootstrapThread = new EhcacheStreamClientThread(ehcache);
            streamBootstrapThread.start();
        } else {
            this.doLoad(ehcache);
        }
    }

    private class EhcacheStreamClientThread
    extends Thread {
        private Ehcache _ehcache;

        public EhcacheStreamClientThread(Ehcache ehcache) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ehcache stream client thread for cache " + ehcache.getName()));
            }
            this._ehcache = ehcache;
            this.setDaemon(true);
            this.setName(String.valueOf(EhcacheStreamClientThread.class.getName()) + " - " + ehcache.getName());
            this.setPriority(5);
        }

        @Override
        public void run() {
            block2: {
                try {
                    EhcacheStreamBootstrapCacheLoader.this.doLoad(this._ehcache);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)"Unable to asynchronously stream bootstrap", (Throwable)e2);
                }
            }
        }
    }
}

