/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.captcha.recaptcha;

import com.liferay.portal.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReCaptchaImpl
extends SimpleCaptchaImpl {
    private static final String _TAGLIB_PATH = "/html/taglib/ui/captcha/recaptcha.jsp";
    private static Log _log = LogFactoryUtil.getLog(ReCaptchaImpl.class);

    @Override
    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    @Override
    public void serveImage(HttpServletRequest request, HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean validateChallenge(HttpServletRequest request) throws CaptchaException {
        String reCaptchaChallenge = ParamUtil.getString((HttpServletRequest)request, (String)"recaptcha_challenge_field");
        String reCaptchaResponse = ParamUtil.getString((HttpServletRequest)request, (String)"recaptcha_response_field");
        Http.Options options = new Http.Options();
        options.addPart("challenge", reCaptchaChallenge);
        try {
            options.addPart("privatekey", PrefsPropsUtil.getString("captcha.engine.recaptcha.key.private", PropsValues.CAPTCHA_ENGINE_RECAPTCHA_KEY_PRIVATE));
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
        }
        options.addPart("remoteip", request.getRemoteAddr());
        options.addPart("response", reCaptchaResponse);
        options.setLocation(HttpUtil.protocolize((String)PropsValues.CAPTCHA_ENGINE_RECAPTCHA_URL_VERIFY, (boolean)request.isSecure()));
        options.setPost(true);
        String content = null;
        try {
            content = HttpUtil.URLtoString((Http.Options)options);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            throw new CaptchaTextException();
        }
        if (content == null) {
            _log.error((Object)"reCAPTCHA did not return a result");
            throw new CaptchaTextException();
        }
        String[] messages = content.split("\r?\n");
        if (messages.length < 1) {
            _log.error((Object)("reCAPTCHA did not return a valid result: " + content));
            throw new CaptchaTextException();
        }
        return GetterUtil.getBoolean((String)messages[0]);
    }

    @Override
    protected boolean validateChallenge(PortletRequest portletRequest) throws CaptchaException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        request = PortalUtil.getOriginalServletRequest((HttpServletRequest)request);
        return this.validateChallenge(request);
    }
}

