/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.CacheModeTranslator;
import com.liferay.portal.dao.orm.hibernate.ExceptionTranslator;
import com.liferay.portal.dao.orm.hibernate.LockModeTranslator;
import com.liferay.portal.dao.orm.hibernate.ScrollableResultsImpl;
import com.liferay.portal.dao.orm.hibernate.TypeTranslator;
import com.liferay.portal.kernel.dao.orm.CacheMode;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.ScrollableResults;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@DoPrivileged
public class SQLQueryImpl
implements SQLQuery {
    private String[] _names;
    private org.hibernate.SQLQuery _sqlQuery;
    private boolean _strictName;

    public SQLQueryImpl(org.hibernate.SQLQuery sqlQuery, boolean strictName) {
        this._sqlQuery = sqlQuery;
        this._strictName = strictName;
        if (!this._strictName) {
            this._names = sqlQuery.getNamedParameters();
            Arrays.sort(this._names);
        }
    }

    public SQLQuery addEntity(String alias, Class<?> entityClass) {
        this._sqlQuery.addEntity(alias, entityClass);
        return this;
    }

    public SQLQuery addScalar(String columnAlias, Type type) {
        this._sqlQuery.addScalar(columnAlias, TypeTranslator.translate(type));
        return this;
    }

    public SQLQuery addSynchronizedEntityClass(Class<?> entityClass) {
        this._sqlQuery.addSynchronizedEntityClass(entityClass);
        return this;
    }

    public SQLQuery addSynchronizedEntityClasses(Class<?> ... entityClasses) {
        Class<?>[] classArray = entityClasses;
        int n = entityClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> entityClass = classArray[n2];
            this._sqlQuery.addSynchronizedEntityClass(entityClass);
            ++n2;
        }
        return this;
    }

    public SQLQuery addSynchronizedEntityName(String entityName) {
        this._sqlQuery.addSynchronizedEntityName(entityName);
        return this;
    }

    public SQLQuery addSynchronizedEntityNames(String ... entityNames) {
        String[] stringArray = entityNames;
        int n = entityNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entityName = stringArray[n2];
            this._sqlQuery.addSynchronizedEntityName(entityName);
            ++n2;
        }
        return this;
    }

    public SQLQuery addSynchronizedQuerySpace(String querySpace) {
        this._sqlQuery.addSynchronizedQuerySpace(querySpace);
        return this;
    }

    public SQLQuery addSynchronizedQuerySpaces(String ... querySpaces) {
        String[] stringArray = querySpaces;
        int n = querySpaces.length;
        int n2 = 0;
        while (n2 < n) {
            String querySpace = stringArray[n2];
            this._sqlQuery.addSynchronizedQuerySpace(querySpace);
            ++n2;
        }
        return this;
    }

    @NotPrivileged
    public int executeUpdate() throws ORMException {
        try {
            return this._sqlQuery.executeUpdate();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Iterator iterate() throws ORMException {
        return this.iterate(true);
    }

    @NotPrivileged
    public Iterator iterate(boolean unmodifiable) throws ORMException {
        try {
            return this.list(unmodifiable).iterator();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Object iterateNext() throws ORMException {
        Iterator iterator = this.iterate(false);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @NotPrivileged
    public List<?> list() throws ORMException {
        return this.list(false, false);
    }

    @NotPrivileged
    public List<?> list(boolean unmodifiable) throws ORMException {
        return this.list(true, unmodifiable);
    }

    @NotPrivileged
    public List<?> list(boolean copy, boolean unmodifiable) throws ORMException {
        try {
            List list = this._sqlQuery.list();
            if (unmodifiable) {
                list = new UnmodifiableList(list);
            } else if (copy) {
                list = ListUtil.copy((List)list);
            }
            return list;
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public ScrollableResults scroll() throws ORMException {
        try {
            return new ScrollableResultsImpl(this._sqlQuery.scroll());
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Query setBoolean(int pos, boolean value) {
        this._sqlQuery.setBoolean(pos, value);
        return this;
    }

    public Query setBoolean(String name, boolean value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setBoolean(name, value);
        return this;
    }

    public Query setCacheable(boolean cacheable) {
        this._sqlQuery.setCacheable(cacheable);
        return this;
    }

    public Query setCacheMode(CacheMode cacheMode) {
        this._sqlQuery.setCacheMode(CacheModeTranslator.translate(cacheMode));
        return this;
    }

    public Query setCacheRegion(String cacheRegion) {
        this._sqlQuery.setCacheRegion(cacheRegion);
        return this;
    }

    public Query setDouble(int pos, double value) {
        this._sqlQuery.setDouble(pos, value);
        return this;
    }

    public Query setDouble(String name, double value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setDouble(name, value);
        return this;
    }

    public Query setFirstResult(int firstResult) {
        this._sqlQuery.setFirstResult(firstResult);
        return this;
    }

    public Query setFloat(int pos, float value) {
        this._sqlQuery.setFloat(pos, value);
        return this;
    }

    public Query setFloat(String name, float value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setFloat(name, value);
        return this;
    }

    public Query setInteger(int pos, int value) {
        this._sqlQuery.setInteger(pos, value);
        return this;
    }

    public Query setInteger(String name, int value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setInteger(name, value);
        return this;
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        this._sqlQuery.setLockMode(alias, LockModeTranslator.translate(lockMode));
        return this;
    }

    public Query setLong(int pos, long value) {
        this._sqlQuery.setLong(pos, value);
        return this;
    }

    public Query setLong(String name, long value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setLong(name, value);
        return this;
    }

    public Query setMaxResults(int maxResults) {
        this._sqlQuery.setMaxResults(maxResults);
        return this;
    }

    public Query setSerializable(int pos, Serializable value) {
        this._sqlQuery.setSerializable(pos, value);
        return this;
    }

    public Query setSerializable(String name, Serializable value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setSerializable(name, value);
        return this;
    }

    public Query setShort(int pos, short value) {
        this._sqlQuery.setShort(pos, value);
        return this;
    }

    public Query setShort(String name, short value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setShort(name, value);
        return this;
    }

    public Query setString(int pos, String value) {
        this._sqlQuery.setString(pos, value);
        return this;
    }

    public Query setString(String name, String value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setString(name, value);
        return this;
    }

    public Query setTimestamp(int pos, Timestamp value) {
        this._sqlQuery.setTimestamp(pos, (Date)value);
        return this;
    }

    public Query setTimestamp(String name, Timestamp value) {
        if (!this._strictName && Arrays.binarySearch(this._names, name) < 0) {
            return this;
        }
        this._sqlQuery.setTimestamp(name, (Date)value);
        return this;
    }

    @NotPrivileged
    public Object uniqueResult() throws ORMException {
        try {
            return this._sqlQuery.uniqueResult();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }
}

