/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.GroupWrapper;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserPersonalSite;
import com.liferay.portal.model.impl.GroupBaseImpl;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GroupImpl
extends GroupBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(GroupImpl.class);
    private Group _liveGroup;
    private Group _stagingGroup;
    private UnicodeProperties _typeSettingsProperties;

    public void clearStagingGroup() {
        this._stagingGroup = null;
    }

    public List<Group> getAncestors() throws PortalException, SystemException {
        GroupImpl group = null;
        group = this.isStagingGroup() ? this.getLiveGroup() : this;
        ArrayList<Group> groups = new ArrayList<Group>();
        while (!group.isRoot()) {
            group = group.getParentGroup();
            groups.add(group);
        }
        return groups;
    }

    public List<Group> getChildren(boolean site) throws SystemException {
        return GroupLocalServiceUtil.getGroups((long)this.getCompanyId(), (long)this.getGroupId(), (boolean)site);
    }

    @Deprecated
    public List<Group> getChildrenWithLayouts(boolean site, int start, int end) throws SystemException {
        return this.getChildrenWithLayouts(site, start, end, null);
    }

    public List<Group> getChildrenWithLayouts(boolean site, int start, int end, OrderByComparator obc) throws SystemException {
        return GroupLocalServiceUtil.getLayoutsGroups((long)this.getCompanyId(), (long)this.getGroupId(), (boolean)site, (int)start, (int)end, (OrderByComparator)obc);
    }

    public int getChildrenWithLayoutsCount(boolean site) throws SystemException {
        return GroupLocalServiceUtil.getLayoutsGroupsCount((long)this.getCompanyId(), (long)this.getGroupId(), (boolean)site);
    }

    public long getDefaultPrivatePlid() {
        return this.getDefaultPlid(true);
    }

    public long getDefaultPublicPlid() {
        return this.getDefaultPlid(false);
    }

    public String getDescriptiveName() throws PortalException, SystemException {
        return this.getDescriptiveName(LocaleUtil.getDefault());
    }

    public String getDescriptiveName(Locale locale) throws PortalException, SystemException {
        return GroupLocalServiceUtil.getGroupDescriptiveName((Group)this, (Locale)locale);
    }

    public String getIconURL(ThemeDisplay themeDisplay) {
        String iconURL = String.valueOf(themeDisplay.getPathThemeImages()) + "/common/";
        iconURL = this.isCompany() ? iconURL.concat("global.png") : (this.isLayout() ? iconURL.concat("page.png") : (this.isOrganization() ? iconURL.concat("organization_icon.png") : (this.isUser() ? iconURL.concat("user_icon.png") : iconURL.concat("site_icon.png"))));
        return iconURL;
    }

    public String getLayoutRootNodeName(boolean privateLayout, Locale locale) {
        String pagesName = null;
        pagesName = this.isLayoutPrototype() || this.isLayoutSetPrototype() || this.isUserGroup() ? "pages" : (privateLayout ? (this.isUser() ? "my-dashboard" : "private-pages") : (this.isUser() ? "my-profile" : "public-pages"));
        return LanguageUtil.get((Locale)locale, (String)pagesName);
    }

    public Group getLiveGroup() {
        if (!this.isStagingGroup()) {
            return null;
        }
        try {
            if (this._liveGroup == null) {
                this._liveGroup = GroupLocalServiceUtil.getGroup((long)this.getLiveGroupId());
                if (this._liveGroup instanceof GroupImpl) {
                    GroupImpl groupImpl = (GroupImpl)this._liveGroup;
                    groupImpl._stagingGroup = this;
                } else {
                    this._liveGroup = new GroupWrapper(this._liveGroup){

                        public Group getStagingGroup() {
                            return GroupImpl.this;
                        }
                    };
                }
            }
            return this._liveGroup;
        }
        catch (Exception e2) {
            _log.error((Object)("Error getting live group for " + this.getLiveGroupId()), (Throwable)e2);
            return null;
        }
    }

    public String getLiveParentTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getParentLiveGroupTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public long getOrganizationId() {
        if (this.isOrganization()) {
            if (this.isStagingGroup()) {
                Group liveGroup = this.getLiveGroup();
                return liveGroup.getClassPK();
            }
            return this.getClassPK();
        }
        return 0L;
    }

    public Group getParentGroup() throws PortalException, SystemException {
        long parentGroupId = this.getParentGroupId();
        if (parentGroupId <= 0L) {
            return null;
        }
        return GroupLocalServiceUtil.getGroup((long)parentGroupId);
    }

    public UnicodeProperties getParentLiveGroupTypeSettingsProperties() {
        try {
            if (this.isLayout()) {
                Group parentGroup = GroupLocalServiceUtil.getGroup((long)this.getParentGroupId());
                return parentGroup.getParentLiveGroupTypeSettingsProperties();
            }
            if (this.isStagingGroup()) {
                Group liveGroup = this.getLiveGroup();
                return liveGroup.getTypeSettingsProperties();
            }
        }
        catch (Exception exception) {}
        return this.getTypeSettingsProperties();
    }

    public String getPathFriendlyURL(boolean privateLayout, ThemeDisplay themeDisplay) {
        if (privateLayout) {
            if (this.isUser()) {
                return themeDisplay.getPathFriendlyURLPrivateUser();
            }
            return themeDisplay.getPathFriendlyURLPrivateGroup();
        }
        return themeDisplay.getPathFriendlyURLPublic();
    }

    public LayoutSet getPrivateLayoutSet() {
        LayoutSet layoutSet = null;
        try {
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return layoutSet;
    }

    public int getPrivateLayoutsPageCount() {
        try {
            return LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return 0;
        }
    }

    public LayoutSet getPublicLayoutSet() {
        LayoutSet layoutSet = null;
        try {
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)false);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return layoutSet;
    }

    public int getPublicLayoutsPageCount() {
        try {
            return LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)false);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return 0;
        }
    }

    public String getScopeDescriptiveName(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        if (this.getGroupId() == themeDisplay.getScopeGroupId()) {
            StringBundler sb = new StringBundler(5);
            sb.append(themeDisplay.translate("current-site"));
            sb.append(" ");
            sb.append("(");
            sb.append(HtmlUtil.escape((String)this.getDescriptiveName(themeDisplay.getLocale())));
            sb.append(")");
            return sb.toString();
        }
        if (this.isLayout() && this.getClassPK() == themeDisplay.getPlid()) {
            StringBundler sb = new StringBundler(5);
            sb.append(themeDisplay.translate("current-page"));
            sb.append(" ");
            sb.append("(");
            sb.append(HtmlUtil.escape((String)this.getDescriptiveName(themeDisplay.getLocale())));
            sb.append(")");
            return sb.toString();
        }
        if (this.isLayoutPrototype()) {
            return themeDisplay.translate("default");
        }
        return HtmlUtil.escape((String)this.getDescriptiveName(themeDisplay.getLocale()));
    }

    public String getScopeLabel(ThemeDisplay themeDisplay) {
        String label = "site";
        if (this.getGroupId() == themeDisplay.getScopeGroupId()) {
            label = "current-site";
        } else if (this.getGroupId() == themeDisplay.getCompanyGroupId()) {
            label = "global";
        } else if (this.isLayout()) {
            label = "page";
        } else {
            Group scopeGroup = themeDisplay.getScopeGroup();
            if (scopeGroup.hasAncestor(this.getGroupId())) {
                label = "parent-site";
            } else if (this.hasAncestor(scopeGroup.getGroupId())) {
                label = "child-site";
            }
        }
        return label;
    }

    public Group getStagingGroup() {
        if (this.isStagingGroup()) {
            return null;
        }
        try {
            if (this._stagingGroup == null) {
                this._stagingGroup = GroupLocalServiceUtil.getStagingGroup((long)this.getGroupId());
                if (this._stagingGroup instanceof GroupImpl) {
                    GroupImpl groupImpl = (GroupImpl)this._stagingGroup;
                    groupImpl._liveGroup = this;
                } else {
                    this._stagingGroup = new GroupWrapper(this._stagingGroup){

                        public Group getLiveGroup() {
                            return GroupImpl.this;
                        }
                    };
                }
            }
            return this._stagingGroup;
        }
        catch (Exception e2) {
            _log.error((Object)("Error getting staging group for " + this.getGroupId()), (Throwable)e2);
            return null;
        }
    }

    public String getTypeLabel() {
        return GroupConstants.getTypeLabel((int)this.getType());
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            try {
                this._typeSettingsProperties.load(super.getTypeSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._typeSettingsProperties;
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public boolean hasAncestor(long groupId) {
        GroupImpl group = null;
        group = this.isStagingGroup() ? this.getLiveGroup() : this;
        String treePath = group.getTreePath();
        return groupId != group.getGroupId() && treePath.contains("/" + groupId + "/");
    }

    public boolean hasLocalOrRemoteStagingGroup() {
        return this.hasStagingGroup() || this.getRemoteStagingGroupCount() > 0;
    }

    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean hasStagingGroup() {
        if (this.isStagingGroup()) {
            return false;
        }
        if (this._stagingGroup != null) {
            return true;
        }
        try {
            return GroupLocalServiceUtil.hasStagingGroup((long)this.getGroupId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isChild(long groupId) {
        return this.hasAncestor(groupId);
    }

    public boolean isCommunity() {
        return this.isRegularSite();
    }

    public boolean isCompany() {
        return this.hasClassName(Company.class) || this.isCompanyStagingGroup();
    }

    public boolean isCompanyStagingGroup() {
        Group liveGroup = this.getLiveGroup();
        if (liveGroup == null) {
            return false;
        }
        return liveGroup.isCompany();
    }

    public boolean isControlPanel() {
        String name = this.getName();
        return name.equals("Control Panel");
    }

    public boolean isGuest() {
        String name = this.getName();
        return name.equals("Guest");
    }

    public boolean isInStagingPortlet(String portletId) {
        Group liveGroup = this.getLiveGroup();
        if (liveGroup == null) {
            return false;
        }
        return liveGroup.isStagedPortlet(portletId);
    }

    public boolean isLayout() {
        return this.hasClassName(Layout.class);
    }

    public boolean isLayoutPrototype() {
        return this.hasClassName(LayoutPrototype.class);
    }

    public boolean isLayoutSetPrototype() {
        return this.hasClassName(LayoutSetPrototype.class);
    }

    public boolean isLimitedToParentSiteMembers() {
        return this.getParentGroupId() != 0L && this.getMembershipRestriction() == 1;
    }

    public boolean isOrganization() {
        return this.hasClassName(Organization.class);
    }

    public boolean isRegularSite() {
        return this.hasClassName(Group.class);
    }

    public boolean isRoot() {
        return this.getParentGroupId() == 0L;
    }

    public boolean isShowSite(PermissionChecker permissionChecker, boolean privateSite) throws PortalException, SystemException {
        if (!(this.isControlPanel() || this.isSite() || this.isUser())) {
            return false;
        }
        boolean showSite = true;
        Layout defaultLayout = null;
        int siteLayoutsCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)privateSite);
        if (siteLayoutsCount == 0) {
            boolean hasPowerUserRole = RoleLocalServiceUtil.hasUserRole((long)permissionChecker.getUserId(), (long)permissionChecker.getCompanyId(), (String)"Power User", (boolean)true);
            if (this.isSite()) {
                showSite = privateSite ? PropsValues.MY_SITES_SHOW_PRIVATE_SITES_WITH_NO_LAYOUTS : PropsValues.MY_SITES_SHOW_PUBLIC_SITES_WITH_NO_LAYOUTS;
            } else if (this.isOrganization()) {
                showSite = false;
            } else if (this.isUser()) {
                if (privateSite) {
                    showSite = PropsValues.MY_SITES_SHOW_USER_PRIVATE_SITES_WITH_NO_LAYOUTS;
                    if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED && !hasPowerUserRole) {
                        showSite = false;
                    }
                } else {
                    showSite = PropsValues.MY_SITES_SHOW_USER_PUBLIC_SITES_WITH_NO_LAYOUTS;
                    if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED && !hasPowerUserRole) {
                        showSite = false;
                    }
                }
            }
        } else {
            defaultLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)this.getGroupId(), (boolean)privateSite, (long)0L);
            if (defaultLayout != null && !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)defaultLayout, (boolean)true, (String)"VIEW")) {
                showSite = false;
            } else if (this.isOrganization() && !this.isSite()) {
                _log.error((Object)("Group " + this.getGroupId() + " is an organization site that does not have pages"));
            }
        }
        return showSite;
    }

    public boolean isStaged() {
        return GetterUtil.getBoolean((String)this.getLiveParentTypeSettingsProperty("staged"));
    }

    public boolean isStagedPortlet(String portletId) {
        UnicodeProperties typeSettingsProperties = this.getParentLiveGroupTypeSettingsProperties();
        String typeSettingsProperty = typeSettingsProperties.getProperty(StagingUtil.getStagedPortletId((String)(portletId = PortletConstants.getRootPortletId((String)portletId))));
        if (Validator.isNotNull((String)typeSettingsProperty)) {
            return GetterUtil.getBoolean((String)typeSettingsProperty);
        }
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
            String portletDataHandlerClass = portlet.getPortletDataHandlerClass();
            for (Map.Entry entry : typeSettingsProperties.entrySet()) {
                String stagedPortletId;
                Portlet stagedPortlet;
                String key = (String)entry.getKey();
                if (!key.contains("staged-portlet_") || !portletDataHandlerClass.equals((stagedPortlet = PortletLocalServiceUtil.getPortletById((String)(stagedPortletId = StringUtil.replace((String)key, (String)"staged-portlet_", (String)"")))).getPortletDataHandlerClass())) continue;
                return GetterUtil.getBoolean((String)((String)entry.getValue()));
            }
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean isStagedRemotely() {
        return GetterUtil.getBoolean((String)this.getLiveParentTypeSettingsProperty("stagedRemotely"));
    }

    public boolean isStagingGroup() {
        return this.getLiveGroupId() != 0L;
    }

    public boolean isUser() {
        return this.hasClassName(User.class);
    }

    public boolean isUserGroup() {
        return this.hasClassName(UserGroup.class);
    }

    public boolean isUserPersonalSite() {
        return this.hasClassName(UserPersonalSite.class);
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }

    protected long getDefaultPlid(boolean privateLayout) {
        block3: {
            try {
                Layout firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)this.getGroupId(), (boolean)privateLayout, (long)0L);
                if (firstLayout != null) {
                    return firstLayout.getPlid();
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e2.getMessage());
            }
        }
        return 0L;
    }

    protected boolean hasClassName(Class<?> clazz) {
        long classNameId = this.getClassNameId();
        return classNameId == PortalUtil.getClassNameId(clazz);
    }
}

