/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.parsers.creole.ast;

import com.liferay.portal.parsers.creole.ast.ASTNode;
import com.liferay.portal.util.PropsUtil;

public abstract class URLNode
extends ASTNode {
    private String _link;
    private String[] _supportedProtocols = PropsUtil.getArray("wiki.parsers.creole.supported.protocols");

    public URLNode() {
    }

    public URLNode(int token) {
        super(token);
    }

    public URLNode(int token, String link) {
        this(token);
        this._link = link;
    }

    public URLNode(String link) {
        this._link = link;
    }

    public String getLink() {
        return this._link;
    }

    public String[] getSupportedProtocols() {
        return this._supportedProtocols;
    }

    public boolean isAbsoluteLink() {
        String[] stringArray = this.getSupportedProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedProtocol = stringArray[n2];
            if (this._link.startsWith(supportedProtocol)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setLink(String link) {
        this._link = link;
    }

    public void setSupportedProtocols(String[] supportedProtocols) {
        this._supportedProtocols = supportedProtocols;
    }
}

