/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.action;

import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.resiliency.spi.agent.SPIAgentRequest;
import com.liferay.portal.resiliency.spi.agent.SPIAgentResponse;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import java.util.List;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PortalResiliencyAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SPIAgentRequest spiAgentRequest = (SPIAgentRequest)request.getAttribute("SPI_AGENT_REQUEST");
        HttpSession session = request.getSession();
        spiAgentRequest.populateSessionAttributes(session);
        PrincipalThreadLocal.setPassword((String)((String)session.getAttribute("USER_PASSWORD")));
        try {
            this._doExecute(request, response);
        }
        finally {
            SPIAgentResponse spiAgentResponse = (SPIAgentResponse)request.getAttribute("SPI_AGENT_RESPONSE");
            spiAgentResponse.captureRequestSessionAttributes(request);
            request.setAttribute("PORTAL_RESILIENCY_ACTION", (Object)Boolean.TRUE);
        }
        return null;
    }

    private void _doExecute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PortletContainer portletContainer = PortletContainerUtil.getPortletContainer();
        Portlet portlet = (Portlet)request.getAttribute("SPI_AGENT_PORTLET");
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (portletId.equals(portlet.getPortletId())) {
            portletContainer.preparePortlet(request, portlet);
        }
        SPIAgent.Lifecycle lifecycle = (SPIAgent.Lifecycle)request.getAttribute("SPI_AGENT_LIFECYCLE");
        switch (lifecycle) {
            case ACTION: {
                Layout requestLayout = (Layout)request.getAttribute("LAYOUT");
                String typeSettings = requestLayout.getTypeSettings();
                ActionResult actionResult = portletContainer.processAction(request, response, portlet);
                String newTypeSettings = requestLayout.getTypeSettings();
                if (!newTypeSettings.equals(typeSettings)) {
                    request.setAttribute("SPI_AGENT_LAYOUT_TYPE_SETTINGS", (Object)newTypeSettings);
                }
                request.setAttribute("SPI_AGENT_ACTION_RESULT", (Object)actionResult);
                break;
            }
            case EVENT: {
                Layout requestLayout = (Layout)request.getAttribute("LAYOUT");
                String typeSettings = requestLayout.getTypeSettings();
                Layout layout = (Layout)request.getAttribute("SPI_AGENT_LAYOUT");
                Event event = (Event)request.getAttribute("SPI_AGENT_EVENT");
                List events = portletContainer.processEvent(request, response, portlet, layout, event);
                String newTypeSettings = requestLayout.getTypeSettings();
                if (!newTypeSettings.equals(typeSettings)) {
                    request.setAttribute("SPI_AGENT_LAYOUT_TYPE_SETTINGS", (Object)newTypeSettings);
                }
                request.setAttribute("SPI_AGENT_EVENT_RESULT", (Object)events);
                break;
            }
            case RENDER: {
                portletContainer.render(request, response, portlet);
                break;
            }
            case RESOURCE: {
                portletContainer.serveResource(request, response, portlet);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown lifecycle " + lifecycle);
            }
        }
    }
}

