/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.server.capabilities;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.server.DeepNamedValueScanner;
import com.liferay.portal.server.capabilities.ServerCapabilities;
import javax.servlet.ServletContext;

public class GlassfishServerCapabilities
implements ServerCapabilities {
    private boolean _supportsHotDeploy;

    @Override
    public void determine(ServletContext servletContext) throws Exception {
        this.determineSupportsHotDeploy(servletContext);
    }

    @Override
    public boolean isSupportsHotDeploy() {
        return this._supportsHotDeploy;
    }

    protected void determineSupportsHotDeploy(ServletContext servletContext) throws Exception {
        DeepNamedValueScanner deepNamedValueScanner = new DeepNamedValueScanner("masterView");
        deepNamedValueScanner.setExcludedClassNames("org.apache.felix.");
        deepNamedValueScanner.setSkipFirstCount(4);
        deepNamedValueScanner.scan(servletContext);
        if (deepNamedValueScanner.isScanning()) {
            this._supportsHotDeploy = false;
            return;
        }
        Object masterViewObject = deepNamedValueScanner.getMatchedValue();
        deepNamedValueScanner = new DeepNamedValueScanner("autodeploy-enabled");
        deepNamedValueScanner.setExcludedClassNames("org.apache.felix.", "CountStatisticImpl");
        deepNamedValueScanner.setSkipFirstCount(2);
        deepNamedValueScanner.setVisitMaps(true);
        deepNamedValueScanner.scan(masterViewObject);
        boolean autoDeployEnabled = true;
        if (!deepNamedValueScanner.isScanning()) {
            autoDeployEnabled = GetterUtil.getBoolean((Object)deepNamedValueScanner.getMatchedValue());
        }
        this._supportsHotDeploy = autoDeployEnabled;
    }
}

