/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.ContactBirthdayException;
import com.liferay.portal.ContactClassNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.ContactLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

public class ContactLocalServiceImpl
extends ContactLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public Contact addContact(long userId, String className, long classPK, String emailAddress, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, ContactBirthdayException.class);
        Date now = new Date();
        this.validate(className, classPK);
        long contactId = this.counterLocalService.increment();
        Contact contact = this.contactPersistence.create(contactId);
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(user.getUserId());
        contact.setUserName(user.getFullName());
        contact.setCreateDate(now);
        contact.setModifiedDate(now);
        contact.setClassName(className);
        contact.setClassPK(classPK);
        contact.setEmailAddress(emailAddress);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setAimSn(aimSn);
        contact.setFacebookSn(facebookSn);
        contact.setIcqSn(icqSn);
        contact.setJabberSn(jabberSn);
        contact.setMsnSn(msnSn);
        contact.setMySpaceSn(mySpaceSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setYmSn(ymSn);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact);
        return contact;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Contact deleteContact(Contact contact) throws SystemException {
        this.contactPersistence.remove((BaseModel)contact);
        this.addressLocalService.deleteAddresses(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        this.emailAddressLocalService.deleteEmailAddresses(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        this.phoneLocalService.deletePhones(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        this.websiteLocalService.deleteWebsites(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        return contact;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Contact deleteContact(long contactId) throws SystemException {
        Contact contact = this.contactPersistence.fetchByPrimaryKey(contactId);
        if (contact != null) {
            this.deleteContact(contact);
        }
        return contact;
    }

    public List<Contact> getContacts(long classNameId, long classPK, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.contactPersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    public int getContactsCount(long classNameId, long classPK) throws SystemException {
        return this.contactPersistence.countByC_C(classNameId, classPK);
    }

    @Indexable(type=IndexableType.REINDEX)
    public Contact updateContact(long contactId, String emailAddress, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle) throws PortalException, SystemException {
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, ContactBirthdayException.class);
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        contact.setModifiedDate(new Date());
        contact.setEmailAddress(emailAddress);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setAimSn(aimSn);
        contact.setFacebookSn(facebookSn);
        contact.setIcqSn(icqSn);
        contact.setJabberSn(jabberSn);
        contact.setMsnSn(msnSn);
        contact.setMySpaceSn(mySpaceSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setYmSn(ymSn);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact);
        return contact;
    }

    protected void validate(String className, long classPK) throws PortalException {
        if (Validator.isNull((String)className) || className.equals(User.class.getName()) || classPK <= 0L) {
            throw new ContactClassNameException();
        }
    }
}

