/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchAccountException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.impl.AccountImpl;
import com.liferay.portal.model.impl.AccountModelImpl;
import com.liferay.portal.service.persistence.AccountPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AccountPersistenceImpl
extends BasePersistenceImpl<Account>
implements AccountPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AccountImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, AccountImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, AccountImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    private static final String _SQL_SELECT_ACCOUNT = "SELECT account FROM Account account";
    private static final String _SQL_COUNT_ACCOUNT = "SELECT COUNT(account) FROM Account account";
    private static final String _ORDER_BY_ENTITY_ALIAS = "account.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Account exists with the primary key ";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static Log _log = LogFactoryUtil.getLog(AccountPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type", "size"});
    private static Account _nullAccount = new AccountImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<Account> toCacheModel() {
            return _nullAccountCacheModel;
        }
    };
    private static CacheModel<Account> _nullAccountCacheModel = new CacheModel<Account>(){

        public Account toEntityModel() {
            return _nullAccount;
        }
    };

    public AccountPersistenceImpl() {
        this.setModelClass(Account.class);
    }

    public void cacheResult(Account account) {
        EntityCacheUtil.putResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()), (Serializable)account);
        account.resetOriginalValues();
    }

    public void cacheResult(List<Account> accounts) {
        for (Account account : accounts) {
            if (EntityCacheUtil.getResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey())) == null) {
                this.cacheResult(account);
                continue;
            }
            account.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)AccountImpl.class.getName());
        }
        EntityCacheUtil.clearCache((String)AccountImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Account account) {
        EntityCacheUtil.removeResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<Account> accounts) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Account account : accounts) {
            EntityCacheUtil.removeResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()));
        }
    }

    public Account create(long accountId) {
        AccountImpl account = new AccountImpl();
        account.setNew(true);
        account.setPrimaryKey(accountId);
        return account;
    }

    public Account remove(long accountId) throws NoSuchAccountException, SystemException {
        return this.remove(Long.valueOf(accountId));
    }

    public Account remove(Serializable primaryKey) throws NoSuchAccountException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            Account account = (Account)session.get(AccountImpl.class, primaryKey);
            if (account == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Account account2 = (Account)this.remove((BaseModel)account);
            return account2;
        }
        catch (NoSuchAccountException nsee) {
            throw nsee;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Account removeImpl(Account account) throws SystemException {
        account = this.toUnwrappedModel(account);
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (!session.contains((Object)account)) {
                    account = (Account)session.get(AccountImpl.class, account.getPrimaryKeyObj());
                }
                if (account != null) {
                    session.delete((Object)account);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        if (account != null) {
            this.clearCache(account);
        }
        return account;
    }

    public Account updateImpl(Account account) throws SystemException {
        account = this.toUnwrappedModel(account);
        boolean isNew = account.isNew();
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (account.isNew()) {
                    session.save((Object)account);
                    account.setNew(false);
                } else {
                    session.merge((Object)account);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        EntityCacheUtil.putResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()), (Serializable)account);
        return account;
    }

    protected Account toUnwrappedModel(Account account) {
        if (account instanceof AccountImpl) {
            return account;
        }
        AccountImpl accountImpl = new AccountImpl();
        accountImpl.setNew(account.isNew());
        accountImpl.setPrimaryKey(account.getPrimaryKey());
        accountImpl.setAccountId(account.getAccountId());
        accountImpl.setCompanyId(account.getCompanyId());
        accountImpl.setUserId(account.getUserId());
        accountImpl.setUserName(account.getUserName());
        accountImpl.setCreateDate(account.getCreateDate());
        accountImpl.setModifiedDate(account.getModifiedDate());
        accountImpl.setParentAccountId(account.getParentAccountId());
        accountImpl.setName(account.getName());
        accountImpl.setLegalName(account.getLegalName());
        accountImpl.setLegalId(account.getLegalId());
        accountImpl.setLegalType(account.getLegalType());
        accountImpl.setSicCode(account.getSicCode());
        accountImpl.setTickerSymbol(account.getTickerSymbol());
        accountImpl.setIndustry(account.getIndustry());
        accountImpl.setType(account.getType());
        accountImpl.setSize(account.getSize());
        return accountImpl;
    }

    public Account findByPrimaryKey(Serializable primaryKey) throws NoSuchAccountException, SystemException {
        Account account = this.fetchByPrimaryKey(primaryKey);
        if (account == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return account;
    }

    public Account findByPrimaryKey(long accountId) throws NoSuchAccountException, SystemException {
        return this.findByPrimaryKey(Long.valueOf(accountId));
    }

    public Account fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        Account account = (Account)EntityCacheUtil.getResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)primaryKey);
        if (account == _nullAccount) {
            return null;
        }
        if (account == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    account = (Account)session.get(AccountImpl.class, primaryKey);
                    if (account != null) {
                        this.cacheResult(account);
                    } else {
                        EntityCacheUtil.putResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)primaryKey, (Serializable)_nullAccount);
                    }
                }
                catch (Exception e2) {
                    EntityCacheUtil.removeResult((boolean)AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)primaryKey);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return account;
    }

    public Account fetchByPrimaryKey(long accountId) throws SystemException {
        return this.fetchByPrimaryKey(Long.valueOf(accountId));
    }

    public List<Account> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<Account> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<Account> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_ACCOUNT);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ACCOUNT;
                if (pagination) {
                    sql = sql.concat(" ORDER BY account.accountId ASC");
                }
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() throws SystemException {
        for (Account account : this.findAll()) {
            this.remove((BaseModel)account);
        }
    }

    public int countAll() throws SystemException {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_ACCOUNT);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portal.model.Account")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((ClassLoader)this.getClassLoader(), (String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)AccountImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

