/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.FileNotFoundException;
import java.util.List;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PortalApplicationContext
extends XmlWebApplicationContext {
    private static Log _log = LogFactoryUtil.getLog(PortalApplicationContext.class);

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        block9: {
            try {
                super.loadBeanDefinitions(xmlBeanDefinitionReader);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        xmlBeanDefinitionReader.setResourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver());
        if (PropsValues.SPRING_CONFIGS == null) {
            return;
        }
        List configLocations = ListUtil.fromArray((Object[])PropsValues.SPRING_CONFIGS);
        if (StringUtil.equalsIgnoreCase((String)PropsValues.PERSISTENCE_PROVIDER, (String)"jpa")) {
            configLocations.remove("META-INF/hibernate-spring.xml");
        } else {
            configLocations.remove("META-INF/jpa-spring.xml");
        }
        for (String configLocation : configLocations) {
            try {
                xmlBeanDefinitionReader.loadBeanDefinitions(configLocation);
            }
            catch (Exception e3) {
                Throwable cause = e3.getCause();
                if (cause instanceof FileNotFoundException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)cause.getMessage());
                    continue;
                }
                _log.error((Object)e3, (Throwable)e3);
            }
        }
    }
}

