/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.transaction.BaseTransactionExecutor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class CounterTransactionExecutor
extends BaseTransactionExecutor {
    private static Log _log = LogFactoryUtil.getLog(CounterTransactionExecutor.class);

    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttribute transactionAttribute, MethodInvocation methodInvocation) throws Throwable {
        TransactionStatus transactionStatus = platformTransactionManager.getTransaction((TransactionDefinition)transactionAttribute);
        Object returnValue = null;
        try {
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.processThrowable(platformTransactionManager, throwable, transactionAttribute, transactionStatus);
        }
        this.processCommit(platformTransactionManager, transactionStatus);
        return returnValue;
    }

    protected void processCommit(PlatformTransactionManager platformTransactionManager, TransactionStatus transactionStatus) {
        try {
            platformTransactionManager.commit(transactionStatus);
        }
        catch (TransactionSystemException tse) {
            _log.error((Object)"Application exception overridden by commit exception", (Throwable)tse);
            throw tse;
        }
        catch (RuntimeException re) {
            _log.error((Object)"Application exception overridden by commit exception", (Throwable)re);
            throw re;
        }
        catch (Error e2) {
            _log.error((Object)"Application exception overridden by commit error", (Throwable)e2);
            throw e2;
        }
    }

    protected void processThrowable(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) throws Throwable {
        if (transactionAttribute.rollbackOn(throwable)) {
            try {
                platformTransactionManager.rollback(transactionStatus);
            }
            catch (TransactionSystemException tse) {
                _log.error((Object)"Application exception overridden by rollback exception", (Throwable)tse);
                throw tse;
            }
            catch (RuntimeException re) {
                _log.error((Object)"Application exception overridden by rollback exception", (Throwable)re);
                throw re;
            }
            catch (Error e2) {
                _log.error((Object)"Application exception overridden by rollback error", (Throwable)e2);
                throw e2;
            }
        } else {
            this.processCommit(platformTransactionManager, transactionStatus);
        }
        throw throwable;
    }
}

