/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.tools.comparator.JavaMethodComparator;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import com.liferay.portal.util.InitUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.TreeSet;

public class CopyInterfaceBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new CopyInterfaceBuilder(args[0], args[1]);
    }

    public CopyInterfaceBuilder(String parentDir, String srcFile) {
        try {
            this._copyInterface(parentDir, srcFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void _copyInterface(String parentDir, String srcFile) throws IOException {
        JavaClass javaClass = this._getJavaClass(parentDir, srcFile);
        JavaMethod[] methods = javaClass.getMethods();
        Arrays.sort(methods, new JavaMethodComparator());
        StringBundler sb = new StringBundler();
        sb.append("package ");
        sb.append(javaClass.getPackage().getName());
        sb.append(";");
        sb.append("[$IMPORTS$]");
        sb.append("public class Copy");
        sb.append(javaClass.getName());
        sb.append(" implements ");
        sb.append(javaClass.getName());
        sb.append(" {");
        String varName = "_" + TextFormatter.format((String)javaClass.getName(), (int)8);
        TreeSet<String> imports = new TreeSet<String>();
        int i2 = 0;
        while (i2 < methods.length) {
            JavaMethod javaMethod = methods[i2];
            String methodName = javaMethod.getName();
            if (javaMethod.isPublic()) {
                String returnValueName = javaMethod.getReturns().getValue();
                imports.add(returnValueName);
                sb.append("public ");
                sb.append(javaMethod.getReturns().getJavaClass().getName());
                sb.append(this._getDimensions(javaMethod.getReturns()));
                sb.append(" ");
                sb.append(methodName);
                sb.append("(");
                JavaParameter[] parameters = javaMethod.getParameters();
                int j = 0;
                while (j < parameters.length) {
                    JavaParameter javaParameter = parameters[j];
                    sb.append(javaParameter.getType().getJavaClass().getName());
                    sb.append(this._getDimensions(javaParameter.getType()));
                    sb.append(" ");
                    sb.append(javaParameter.getName());
                    sb.append(", ");
                    imports.add(javaParameter.getType().getValue());
                    ++j;
                }
                if (parameters.length > 0) {
                    sb.setIndex(sb.index() - 1);
                }
                sb.append(")");
                Type[] thrownExceptions = javaMethod.getExceptions();
                LinkedHashSet<String> newExceptions = new LinkedHashSet<String>();
                int j2 = 0;
                while (j2 < thrownExceptions.length) {
                    Type thrownException = thrownExceptions[j2];
                    newExceptions.add(thrownException.getJavaClass().getName());
                    imports.add(thrownException.getValue());
                    ++j2;
                }
                if (newExceptions.size() > 0) {
                    sb.append(" throws ");
                    for (String newException : newExceptions) {
                        sb.append(newException);
                        sb.append(", ");
                    }
                    sb.setIndex(sb.index() - 1);
                }
                sb.append("{");
                if (!returnValueName.equals("void")) {
                    sb.append("return ");
                }
                sb.append(varName);
                sb.append(".");
                sb.append(methodName);
                sb.append("(");
                j2 = 0;
                while (j2 < parameters.length) {
                    JavaParameter javaParameter = parameters[j2];
                    sb.append(javaParameter.getName());
                    sb.append(", ");
                    ++j2;
                }
                if (parameters.length > 0) {
                    sb.setIndex(sb.index() - 1);
                }
                sb.append(");");
                sb.append("}");
            }
            ++i2;
        }
        sb.append("private ");
        sb.append(javaClass.getName());
        sb.append(" ");
        sb.append(varName);
        sb.append(";");
        sb.append("}");
        String content = sb.toString();
        sb = new StringBundler(imports.size() * 3);
        for (String importClass : imports) {
            if (importClass.equals("boolean") || importClass.equals("byte") || importClass.equals("double") || importClass.equals("float") || importClass.equals("int") || importClass.equals("long") || importClass.equals("short") || importClass.equals("void")) continue;
            sb.append("import ");
            sb.append(importClass);
            sb.append(";");
        }
        content = StringUtil.replace((String)content, (String)"[$IMPORTS$]", (String)sb.toString());
        File file = new File(String.valueOf(parentDir) + "/" + StringUtil.replace((String)javaClass.getPackage().getName(), (String)".", (String)"/") + "/Copy" + javaClass.getName() + ".java");
        ServiceBuilder.writeFile(file, content);
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        int i2 = 0;
        while (i2 < type.getDimensions()) {
            dimensions = String.valueOf(dimensions) + "[]";
            ++i2;
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String parentDir, String srcFile) throws IOException {
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new File(String.valueOf(parentDir) + "/" + srcFile));
        return builder.getClassByName(className);
    }
}

