/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.PwdGenerator;
import com.liferay.util.ant.ExpandTask;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tools.ant.DirectoryScanner;
import org.mozilla.intl.chardet.nsDetector;

@DoPrivileged
public class FileImpl
implements File {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"&", ")", "(", ";"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{"_AMP_", "_CP_", "_OP_", "_SEM_"};
    private static Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static FileImpl _instance = new FileImpl();

    public static FileImpl getInstance() {
        return _instance;
    }

    public String appendParentheticalSuffix(String fileName, String suffix) {
        String fileNameWithoutExtension = this.stripExtension(fileName);
        String fileNameWithParentheticalSuffix = StringUtil.appendParentheticalSuffix((String)fileNameWithoutExtension, (String)suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNull((String)extension)) {
            return fileNameWithParentheticalSuffix;
        }
        StringBundler sb = new StringBundler(3);
        sb.append(fileNameWithParentheticalSuffix);
        sb.append(".");
        sb.append(extension);
        return sb.toString();
    }

    public void copyDirectory(java.io.File source, java.io.File destination) throws IOException {
        if (!source.exists() || !source.isDirectory()) {
            return;
        }
        this.mkdirs(destination);
        java.io.File[] fileArray = source.listFiles();
        int i2 = 0;
        while (i2 < fileArray.length) {
            if (fileArray[i2].isDirectory()) {
                this.copyDirectory(fileArray[i2], new java.io.File(String.valueOf(destination.getPath()) + java.io.File.separator + fileArray[i2].getName()));
            } else {
                this.copyFile(fileArray[i2], new java.io.File(String.valueOf(destination.getPath()) + java.io.File.separator + fileArray[i2].getName()));
            }
            ++i2;
        }
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        this.copyDirectory(new java.io.File(sourceDirName), new java.io.File(destinationDirName));
    }

    public void copyFile(java.io.File source, java.io.File destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(java.io.File source, java.io.File destination, boolean lazy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String oldContent = null;
            try {
                oldContent = this.read(source);
            }
            catch (Exception exception) {
                return;
            }
            String newContent = null;
            try {
                newContent = this.read(destination);
            }
            catch (Exception exception) {}
            if (oldContent == null || !oldContent.equals(newContent)) {
                this.copyFile(source, destination, false);
            }
        } else {
            this.mkdirsParentFile(destination);
            StreamUtil.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(destination));
        }
    }

    public void copyFile(String source, String destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(String source, String destination, boolean lazy) throws IOException {
        this.copyFile(new java.io.File(source), new java.io.File(destination), lazy);
    }

    public java.io.File createTempFile() {
        return this.createTempFile("");
    }

    public java.io.File createTempFile(byte[] bytes) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, bytes, false);
        return file;
    }

    public java.io.File createTempFile(InputStream is) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, is);
        return file;
    }

    public java.io.File createTempFile(String extension) {
        return new java.io.File(this.createTempFileName(extension));
    }

    public java.io.File createTempFile(String prefix, String extension) {
        return new java.io.File(this.createTempFileName(prefix, extension));
    }

    public String createTempFileName() {
        return this.createTempFileName(null, null);
    }

    public String createTempFileName(String extension) {
        return this.createTempFileName(null, extension);
    }

    public String createTempFileName(String prefix, String extension) {
        StringBundler sb = new StringBundler();
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/");
        if (Validator.isNotNull((String)prefix)) {
            sb.append(prefix);
        }
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword((int)8, (String[])new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ"}));
        if (Validator.isFileExtension((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public java.io.File createTempFolder() throws IOException {
        java.io.File file = new java.io.File(this.createTempFileName());
        this.mkdirs(file);
        return file;
    }

    public String decodeSafeFileName(String fileName) {
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_2, (String[])_SAFE_FILE_NAME_1);
    }

    public boolean delete(java.io.File file) {
        if (file != null) {
            boolean exists = true;
            try {
                exists = file.exists();
            }
            catch (SecurityException securityException) {}
            if (exists) {
                return file.delete();
            }
        }
        return false;
    }

    public boolean delete(String file) {
        return this.delete(new java.io.File(file));
    }

    public void deltree(java.io.File directory) {
        if (directory.exists() && directory.isDirectory()) {
            java.io.File[] fileArray = directory.listFiles();
            int i2 = 0;
            while (i2 < fileArray.length) {
                if (fileArray[i2].isDirectory()) {
                    this.deltree(fileArray[i2]);
                } else {
                    fileArray[i2].delete();
                }
                ++i2;
            }
            directory.delete();
        }
    }

    public void deltree(String directory) {
        this.deltree(new java.io.File(directory));
    }

    public String encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_1, (String[])_SAFE_FILE_NAME_2);
    }

    public boolean exists(java.io.File file) {
        return file.exists();
    }

    public boolean exists(String fileName) {
        return this.exists(new java.io.File(fileName));
    }

    public String extractText(InputStream is, String fileName) {
        return this.extractText(is, fileName, -1);
    }

    public String extractText(InputStream is, String fileName, int maxStringLength) {
        String text;
        block23: {
            text = null;
            ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
            ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
            try {
                try {
                    String mimeType;
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(portalClassLoader);
                    }
                    Tika tika = new Tika();
                    tika.setMaxStringLength(maxStringLength);
                    boolean forkProcess = false;
                    if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)(mimeType = tika.detect(is)))) {
                        forkProcess = true;
                    }
                    if (forkProcess) {
                        Future future = ProcessExecutor.execute((String)ClassPathUtil.getPortalClassPath(), (ProcessCallable)new ExtractTextProcessCallable(this.getBytes(is)));
                        text = (String)future.get();
                    } else {
                        text = tika.parseToString(is);
                    }
                }
                catch (Exception e2) {
                    Throwable throwable = ExceptionUtils.getRootCause((Throwable)e2);
                    if (throwable instanceof CryptographyException || throwable instanceof EncryptedDocumentException || throwable instanceof UnsupportedZipFeatureException) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to extract text from an encrypted file " + fileName));
                        }
                    } else if (e2 instanceof TikaException) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to extract text from " + fileName));
                        }
                    } else {
                        _log.error((Object)e2, (Throwable)e2);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    ClassLoaderUtil.setContextClassLoader(contextClassLoader);
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
        if (_log.isInfoEnabled()) {
            if (text == null) {
                _log.info((Object)("Text extraction failed for " + fileName));
            } else {
                _log.info((Object)("Text was extracted for " + fileName));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Extractor returned text:\n\n" + text));
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String[] find(String directory, String includes, String excludes) {
        if (directory.length() > 0 && (directory = this.replaceSeparator(directory)).charAt(directory.length() - 1) == '/') {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (!this.exists(directory)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Directory " + directory + " does not exist"));
            }
            return new String[0];
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(directory);
        directoryScanner.setExcludes(StringUtil.split((String)excludes));
        directoryScanner.setIncludes(StringUtil.split((String)includes));
        directoryScanner.scan();
        String[] includedFiles = directoryScanner.getIncludedFiles();
        int i2 = 0;
        while (i2 < includedFiles.length) {
            includedFiles[i2] = directory.concat("/").concat(this.replaceSeparator(includedFiles[i2]));
            ++i2;
        }
        return includedFiles;
    }

    public String getAbsolutePath(java.io.File file) {
        return StringUtil.replace((String)file.getAbsolutePath(), (char)'\\', (char)'/');
    }

    public byte[] getBytes(java.io.File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] bytes = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(bytes);
        randomAccessFile.close();
        return bytes;
    }

    public byte[] getBytes(InputStream is) throws IOException {
        return this.getBytes(is, -1);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        return this.getBytes(inputStream, bufferSize, true);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)bufferSize, (boolean)cleanUpStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return StringUtil.toLowerCase((String)fileName.substring(pos + 1, fileName.length()));
        }
        return "";
    }

    public String getMD5Checksum(java.io.File file) throws IOException {
        String string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            string = DigesterUtil.digestHex((String)"MD5", (InputStream)fileInputStream);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(fileInputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)fileInputStream);
        return string;
    }

    public String getPath(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        if (x == -1 && y == -1) {
            return "/";
        }
        String shortFileName = fullFileName.substring(0, Math.max(x, y));
        return shortFileName;
    }

    public String getShortFileName(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        String shortFileName = fullFileName.substring(Math.max(x, y) + 1);
        return shortFileName;
    }

    public boolean isAscii(java.io.File file) throws IOException {
        boolean ascii = true;
        nsDetector detector = new nsDetector(0);
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1) {
            if (ascii && !(ascii = detector.isAscii(buffer, len))) break;
        }
        detector.DataEnd();
        ((InputStream)inputStream).close();
        return ascii;
    }

    /*
     * Exception decompiling
     */
    public boolean isSameContent(java.io.File file, byte[] bytes, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isSameContent(java.io.File file, String s) {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (String)s);
        return this.isSameContent(file, byteBuffer.array(), byteBuffer.limit());
    }

    public String[] listDirs(java.io.File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        int i2 = 0;
        while (fileArray != null && i2 < fileArray.length) {
            if (fileArray[i2].isDirectory()) {
                dirs.add(fileArray[i2].getName());
            }
            ++i2;
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    public String[] listDirs(String fileName) {
        return this.listDirs(new java.io.File(fileName));
    }

    public String[] listFiles(java.io.File file) {
        ArrayList<String> files = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        int i2 = 0;
        while (fileArray != null && i2 < fileArray.length) {
            if (fileArray[i2].isFile()) {
                files.add(fileArray[i2].getName());
            }
            ++i2;
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] listFiles(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return new String[0];
        }
        return this.listFiles(new java.io.File(fileName));
    }

    public void mkdirs(java.io.File file) throws IOException {
        FileUtils.forceMkdir((java.io.File)file);
    }

    public void mkdirs(String pathName) {
        java.io.File file = new java.io.File(pathName);
        if (file.exists() && file.isDirectory()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Directory " + pathName + " already exists"));
            }
            return;
        }
        try {
            this.mkdirs(file);
        }
        catch (IOException ioe) {
            ReflectionUtil.throwException((Throwable)ioe);
        }
    }

    public boolean move(java.io.File source, java.io.File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        try {
            if (source.isDirectory()) {
                FileUtils.moveDirectory((java.io.File)source, (java.io.File)destination);
            } else {
                FileUtils.moveFile((java.io.File)source, (java.io.File)destination);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new java.io.File(sourceFileName), new java.io.File(destinationFileName));
    }

    public String read(java.io.File file) throws IOException {
        return this.read(file, false);
    }

    public String read(java.io.File file, boolean raw) throws IOException {
        byte[] bytes = this.getBytes(file);
        if (bytes == null) {
            return null;
        }
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace((String)s, (String)"\r\n", (String)"\n");
    }

    public String read(String fileName) throws IOException {
        return this.read(new java.io.File(fileName));
    }

    public String replaceSeparator(String fileName) {
        return StringUtil.replace((String)fileName, (char)'\\', (char)'/');
    }

    public java.io.File[] sortFiles(java.io.File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<java.io.File> directoryList = new ArrayList<java.io.File>();
        ArrayList<java.io.File> fileList = new ArrayList<java.io.File>();
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].isDirectory()) {
                directoryList.add(files[i2]);
            } else {
                fileList.add(files[i2]);
            }
            ++i2;
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new java.io.File[directoryList.size()]);
    }

    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = this.getExtension(fileName);
        if (ext.length() > 0) {
            return fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }

    public List<String> toList(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                list.add(line);
            }
            unsyncBufferedReader.close();
        }
        catch (IOException iOException) {}
        return list;
    }

    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException iOException) {
            return new ArrayList<String>();
        }
    }

    public Properties toProperties(FileInputStream fis) {
        Properties properties = new Properties();
        try {
            properties.load(fis);
        }
        catch (IOException iOException) {}
        return properties;
    }

    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException iOException) {
            return new Properties();
        }
    }

    public void touch(java.io.File file) throws IOException {
        FileUtils.touch((java.io.File)file);
    }

    public void touch(String fileName) throws IOException {
        this.touch(new java.io.File(fileName));
    }

    public void unzip(java.io.File source, java.io.File destination) {
        ExpandTask.expand((java.io.File)source, (java.io.File)destination);
    }

    public void write(java.io.File file, byte[] bytes) throws IOException {
        this.write(file, bytes, 0, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, boolean append) throws IOException {
        this.write(file, bytes, 0, bytes.length, append);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
        this.write(file, bytes, offset, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
        this.mkdirsParentFile(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file, append);
        fileOutputStream.write(bytes, offset, length);
        fileOutputStream.close();
    }

    public void write(java.io.File file, InputStream is) throws IOException {
        this.mkdirsParentFile(file);
        StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(file));
    }

    public void write(java.io.File file, String s) throws IOException {
        this.write(file, s, false);
    }

    public void write(java.io.File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    public void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (s == null) {
            return;
        }
        this.mkdirsParentFile(file);
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");
        writer.write(s);
        ((Writer)writer).close();
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new java.io.File(fileName), bytes);
    }

    public void write(String fileName, InputStream is) throws IOException {
        this.write(new java.io.File(fileName), is);
    }

    public void write(String fileName, String s) throws IOException {
        this.write(new java.io.File(fileName), s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(fileName), s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(fileName), s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new java.io.File(pathName, fileName), s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy, append);
    }

    protected void mkdirsParentFile(java.io.File file) throws IOException {
        java.io.File parentFile = file.getParentFile();
        if (parentFile == null) {
            return;
        }
        try {
            this.mkdirs(parentFile);
        }
        catch (SecurityException securityException) {}
    }

    private static class ExtractTextProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private byte[] _data;

        public ExtractTextProcessCallable(byte[] data) {
            this._data = data;
        }

        public String call() throws ProcessException {
            Tika tika = new Tika();
            try {
                return tika.parseToString((InputStream)new UnsyncByteArrayInputStream(this._data));
            }
            catch (Exception e2) {
                throw new ProcessException((Throwable)e2);
            }
        }
    }
}

