/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.amazonrankings;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.amazonrankings.model.AmazonRankings;
import com.liferay.portlet.amazonrankings.util.AmazonRankingsUtil;
import java.util.ArrayList;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;

public class AmazonRankingsPreferencesValidator
implements PreferencesValidator {
    private static Log _log = LogFactoryUtil.getLog(AmazonRankingsPreferencesValidator.class);

    public void validate(PortletPreferences preferences) throws ValidatorException {
        String[] isbns;
        ArrayList<String> badIsbns = new ArrayList<String>();
        String[] stringArray = isbns = preferences.getValues("isbns", new String[0]);
        int n = isbns.length;
        int n2 = 0;
        while (n2 < n) {
            String isbn = stringArray[n2];
            AmazonRankings amazonRankings = AmazonRankingsUtil.getAmazonRankings(isbn);
            if (amazonRankings == null) {
                badIsbns.add(isbn);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Invalid ISBN " + isbn));
                }
            }
            ++n2;
        }
        if (badIsbns.size() > 0) {
            throw new ValidatorException("Failed to retrieve ISBNs", badIsbns);
        }
    }
}

