/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.base.DLFileVersionServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import java.util.List;

public class DLFileVersionServiceImpl
extends DLFileVersionServiceBaseImpl {
    public DLFileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        DLFileVersion fileVersion = this.dlFileVersionLocalService.getFileVersion(fileVersionId);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileVersion.getFileEntryId(), "VIEW");
        return fileVersion;
    }

    public List<DLFileVersion> getFileVersions(long fileEntryId, int status) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileVersionLocalService.getFileVersions(fileEntryId, status);
    }

    public int getFileVersionsCount(long fileEntryId, int status) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileVersionPersistence.countByF_S(fileEntryId, status);
    }

    public DLFileVersion getLatestFileVersion(long fileEntryId) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileVersionLocalService.getLatestFileVersion(this.getGuestOrUserId(), fileEntryId);
    }
}

