/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordImpl;
import com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

public class DDLRecordFinderImpl
extends BasePersistenceImpl<DDLRecord>
implements DDLRecordFinder {
    public static final String COUNT_BY_R_S = String.valueOf(DDLRecordFinder.class.getName()) + ".countByR_S";
    public static final String COUNT_BY_C_S_S = String.valueOf(DDLRecordFinder.class.getName()) + ".countByC_S_S";
    public static final String FIND_BY_R_S = String.valueOf(DDLRecordFinder.class.getName()) + ".findByR_S";
    public static final String FIND_BY_C_S_S = String.valueOf(DDLRecordFinder.class.getName()) + ".findByC_S_S";

    public int countByR_S(long recordSetId, int status) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_R_S);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(DDLRecordVersion.status = ?) AND", (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(recordSetId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_S_S(long companyId, int status, int scope) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_S_S);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(DDLRecordVersion.status = ?) AND", (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(scope);
            qPos.add(companyId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DDLRecord> findByR_S(long recordSetId, int status, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_R_S);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(DDLRecordVersion.status = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)orderByComparator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DDLRecord", DDLRecordImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(recordSetId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DDLRecord> findByC_S_S(long companyId, int status, int scope, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_S_S);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(DDLRecordVersion.status = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)orderByComparator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DDLRecord", DDLRecordImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(scope);
            qPos.add(companyId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Long[] findByC_S_S_MinAndMax(long companyId, int status, int scope) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_S_S);
            sql = StringUtil.replace((String)sql, (String)"COUNT(DISTINCT DDLRecord.recordId) AS COUNT_VALUE", (String)"MIN(DDLRecord.recordId) AS minRecordId, MAX(DDLRecord.recordId) AS maxRecordId");
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(DDLRecordVersion.status = ?) AND", (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("minRecordId", Type.LONG);
            q.addScalar("maxRecordId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(scope);
            qPos.add(companyId);
            Object[] array = (Object[])q.iterateNext();
            if (array == null) {
                return null;
            }
            Long[] longArray = ArrayUtil.toLongArray((Object[])array);
            return longArray;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DDLRecord> findByC_S_S_MinAndMax(long companyId, int status, int scope, long minRecordId, long maxRecordId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_S_S);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(DDLRecordVersion.status = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.removeOrderBy((String)sql);
            sql = String.valueOf(sql) + " AND (DDLRecord.recordId >= ?) AND (DDLRecord.recordId < ?)";
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DDLRecord", DDLRecordImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(scope);
            qPos.add(companyId);
            qPos.add(minRecordId);
            qPos.add(maxRecordId);
            List list = q.list();
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }
}

