/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.model.impl.MDRRuleGroupImpl;
import com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MDRRuleGroupFinderImpl
extends BasePersistenceImpl<MDRRuleGroup>
implements MDRRuleGroupFinder {
    public static final String COUNT_BY_G_N = String.valueOf(MDRRuleGroupFinder.class.getName()) + ".countByG_N";
    public static final String FIND_BY_G_N = String.valueOf(MDRRuleGroupFinder.class.getName()) + ".findByG_N";
    private LinkedHashMap<String, Object> _emptyLinkedHashMap = new LinkedHashMap(0);

    public int countByKeywords(long groupId, String keywords, LinkedHashMap<String, Object> params) throws SystemException {
        String[] names = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countByG_N(groupId, names, params, andOperator);
    }

    public int countByG_N(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        String[] names = CustomSQLUtil.keywords((String)name);
        return this.countByG_N(groupId, names, params, andOperator);
    }

    public int countByG_N(long groupId, String[] names, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N);
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(params));
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(MDRRuleGroup.name)", (String)"LIKE", (boolean)true, (String[])names);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)true);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setGroupIds(qPos, groupId, params);
            qPos.add(names, 2);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MDRRuleGroup> findByKeywords(long groupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        String[] names = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.findByG_N(groupId, names, params, andOperator, start, end);
    }

    public List<MDRRuleGroup> findByG_N(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        return this.findByG_N(groupId, name, params, andOperator, -1, -1);
    }

    public List<MDRRuleGroup> findByG_N(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        String[] names = CustomSQLUtil.keywords((String)name);
        return this.findByG_N(groupId, names, params, andOperator, start, end);
    }

    public List<MDRRuleGroup> findByG_N(long groupId, String[] names, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N);
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(params));
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(MDRRuleGroup.name)", (String)"LIKE", (boolean)true, (String[])names);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("MDRRuleGroup", MDRRuleGroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setGroupIds(qPos, groupId, params);
            qPos.add(names, 2);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getGroupIds(Map<String, Object> params) {
        Boolean includeGlobalScope = (Boolean)params.get("includeGlobalScope");
        if (includeGlobalScope != null && includeGlobalScope.booleanValue()) {
            return "((groupId = ?) OR (groupId = ?))";
        }
        return "(groupId = ?)";
    }

    protected void setGroupIds(QueryPos qPos, long groupId, Map<String, Object> params) throws PortalException, SystemException {
        Boolean includeGlobalScope = (Boolean)params.get("includeGlobalScope");
        if (includeGlobalScope != null && includeGlobalScope.booleanValue()) {
            qPos.add(groupId);
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)group.getCompanyId());
            qPos.add(companyGroup.getGroupId());
        } else {
            qPos.add(groupId);
        }
    }
}

