/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.myaccount.action;

import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.pwd.PwdAuthenticator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.RenderRequestImpl;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditUserAction
extends com.liferay.portlet.usersadmin.action.EditUserAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        if (this.redirectToLogin(actionRequest, actionResponse)) {
            return;
        }
        super.processAction(actionMapping, actionForm, portletConfig, actionRequest, actionResponse);
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        User user = PortalUtil.getUser((PortletRequest)renderRequest);
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)renderRequest;
        DynamicServletRequest dynamicRequest = (DynamicServletRequest)renderRequestImpl.getHttpServletRequest();
        dynamicRequest.setParameter("p_u_i_d", String.valueOf(user.getUserId()));
        return super.render(actionMapping, actionForm, portletConfig, renderRequest, renderResponse);
    }

    @Override
    protected Object[] updateUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String currentPassword = actionRequest.getParameter("password0");
        String newPassword = actionRequest.getParameter("password1");
        if (Validator.isNotNull((String)currentPassword)) {
            if (Validator.isNull((String)newPassword)) {
                throw new UserPasswordException(4);
            }
            Company company = PortalUtil.getCompany((PortletRequest)actionRequest);
            String authType = company.getAuthType();
            User user = PortalUtil.getSelectedUser((PortletRequest)actionRequest);
            String login = null;
            if (authType.equals("emailAddress")) {
                login = user.getEmailAddress();
            } else if (authType.equals("userId")) {
                login = String.valueOf(user.getUserId());
            } else if (authType.equals("screenName")) {
                login = user.getScreenName();
            }
            boolean validPassword = PwdAuthenticator.authenticate(login, currentPassword, user.getPassword());
            if (!validPassword) {
                throw new UserPasswordException(3);
            }
        } else if (Validator.isNotNull((String)newPassword)) {
            throw new UserPasswordException(3);
        }
        return super.updateUser(actionRequest, actionResponse);
    }
}

