/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionPropagator;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PermissionServiceUtil;
import com.liferay.portal.service.PersistedModelLocalService;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockServiceUtil;
import com.liferay.portal.service.ResourcePermissionServiceUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.portletconfiguration.action.ActionUtil;
import com.liferay.portlet.portletconfiguration.util.ConfigurationActionRequest;
import com.liferay.portlet.portletconfiguration.util.ConfigurationRenderRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPermissionsAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            actionRequest = new ConfigurationActionRequest((ActionRequest)actionRequest, new StrictPortletPreferencesImpl());
            this.updateRolePermissions((ActionRequest)actionRequest);
            this.addSuccessMessage((ActionRequest)actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        renderRequest = new ConfigurationRenderRequest((RenderRequest)renderRequest, new StrictPortletPreferencesImpl());
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourceGroupId", (long)themeDisplay.getScopeGroupId());
        String portletResource = ParamUtil.getString((PortletRequest)renderRequest, (String)"portletResource");
        String modelResource = ParamUtil.getString((PortletRequest)renderRequest, (String)"modelResource");
        String resourcePrimKey = ParamUtil.getString((PortletRequest)renderRequest, (String)"resourcePrimKey");
        String selResource = portletResource;
        if (Validator.isNotNull((String)modelResource)) {
            selResource = modelResource;
        }
        try {
            PermissionServiceUtil.checkPermission((long)groupId, (String)selResource, (String)resourcePrimKey);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return actionMapping.findForward("portlet.portlet_configuration.error");
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource);
        if (portlet != null) {
            renderResponse.setTitle(ActionUtil.getTitle(portlet, renderRequest));
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_permissions"));
    }

    protected String[] getActionIds(ActionRequest actionRequest, long roleId, boolean includePreselected) {
        List<String> actionIds = this.getActionIdsList(actionRequest, roleId, includePreselected);
        return actionIds.toArray(new String[actionIds.size()]);
    }

    protected List<String> getActionIdsList(ActionRequest actionRequest, long roleId, boolean includePreselected) {
        ArrayList<String> actionIds = new ArrayList<String>();
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String actionId;
            int pos;
            String name = (String)enu.nextElement();
            if (name.startsWith(String.valueOf(roleId) + "_ACTION_")) {
                pos = name.indexOf("_ACTION_");
                actionId = name.substring(pos + "_ACTION_".length());
                actionIds.add(actionId);
                continue;
            }
            if (!includePreselected || !name.startsWith(String.valueOf(roleId) + "_PRESELECTED_")) continue;
            pos = name.indexOf("_PRESELECTED_");
            actionId = name.substring(pos + "_PRESELECTED_".length());
            actionIds.add(actionId);
        }
        return actionIds;
    }

    protected void updateLayoutModifiedDate(String selResource, String resourcePrimKey) throws Exception {
        long plid = 0L;
        int pos = resourcePrimKey.indexOf("_LAYOUT_");
        if (pos != -1) {
            plid = GetterUtil.getLong((String)resourcePrimKey.substring(0, pos));
        } else if (selResource.equals(Layout.class.getName())) {
            plid = GetterUtil.getLong((String)resourcePrimKey);
        }
        if (plid <= 0L) {
            return;
        }
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        if (layout != null) {
            layout.setModifiedDate(new Date());
            LayoutLocalServiceUtil.updateLayout((Layout)layout);
            CacheUtil.clearCache(layout.getCompanyId());
        }
    }

    protected void updateModifiedDate(String className, String classPK) throws Exception {
        PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)className);
        PersistedModel persistedModel = persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(classPK));
        if (persistedModel instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)persistedModel;
            DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
            dlFileVersion.setModifiedDate(new Date());
            dlFileVersion.setStatusDate(new Date());
            DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
        } else if (persistedModel instanceof BlogsEntry) {
            BlogsEntry blogsEntry = (BlogsEntry)persistedModel;
            blogsEntry.setModifiedDate(new Date());
            BlogsEntryLocalServiceUtil.updateBlogsEntry((BlogsEntry)blogsEntry);
        }
    }

    protected void updateRolePermissions(ActionRequest actionRequest) throws Exception {
        Portlet portlet;
        PermissionPropagator permissionPropagator;
        long roleId;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        String modelResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResource");
        long[] roleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"rolesSearchContainerPrimaryKeys"), (long)0L);
        String selResource = PortletConstants.getRootPortletId((String)portletResource);
        if (Validator.isNotNull((String)modelResource)) {
            selResource = modelResource;
        }
        long resourceGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceGroupId", (long)themeDisplay.getScopeGroupId());
        String resourcePrimKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"resourcePrimKey");
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        if (ResourceBlockLocalServiceUtil.isSupported((String)selResource)) {
            long[] lArray = roleIds;
            int n = roleIds.length;
            int n2 = 0;
            while (n2 < n) {
                roleId = lArray[n2];
                List<String> actionIds = this.getActionIdsList(actionRequest, roleId, true);
                roleIdsToActionIds.put(roleId, actionIds.toArray(new String[actionIds.size()]));
                ++n2;
            }
            ResourceBlockServiceUtil.setIndividualScopePermissions((long)themeDisplay.getCompanyId(), (long)resourceGroupId, (String)selResource, (long)GetterUtil.getLong((String)resourcePrimKey), roleIdsToActionIds);
        } else {
            long[] lArray = roleIds;
            int n = roleIds.length;
            int n3 = 0;
            while (n3 < n) {
                roleId = lArray[n3];
                String[] actionIds = this.getActionIds(actionRequest, roleId, false);
                roleIdsToActionIds.put(roleId, actionIds);
                ++n3;
            }
            ResourcePermissionServiceUtil.setIndividualResourcePermissions((long)resourceGroupId, (long)themeDisplay.getCompanyId(), (String)selResource, (String)resourcePrimKey, roleIdsToActionIds);
        }
        try {
            this.updateModifiedDate(selResource, resourcePrimKey);
        }
        catch (Exception exception) {}
        this.updateLayoutModifiedDate(selResource, resourcePrimKey);
        if (PropsValues.PERMISSIONS_PROPAGATION_ENABLED && (permissionPropagator = (portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource)).getPermissionPropagatorInstance()) != null) {
            permissionPropagator.propagateRolePermissions(actionRequest, modelResource, resourcePrimKey, roleIds);
        }
    }
}

