/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.service.base.ShoppingOrderServiceBaseImpl;
import com.liferay.portlet.shopping.service.permission.ShoppingOrderPermission;
import com.liferay.portlet.shopping.service.permission.ShoppingPermission;

public class ShoppingOrderServiceImpl
extends ShoppingOrderServiceBaseImpl {
    public void completeOrder(long groupId, String number, String ppTxnId, String ppPaymentStatus, double ppPaymentGross, String ppReceiverEmail, String ppPayerEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingOrder order = this.shoppingOrderPersistence.findByNumber(number);
        ShoppingOrderPermission.check(this.getPermissionChecker(), groupId, order.getOrderId(), "UPDATE");
        this.shoppingOrderLocalService.completeOrder(number, ppTxnId, ppPaymentStatus, ppPaymentGross, ppReceiverEmail, ppPayerEmail, false, serviceContext);
    }

    public void deleteOrder(long groupId, long orderId) throws PortalException, SystemException {
        ShoppingOrderPermission.check(this.getPermissionChecker(), groupId, orderId, "DELETE");
        this.shoppingOrderLocalService.deleteOrder(orderId);
    }

    public ShoppingOrder getOrder(long groupId, long orderId) throws PortalException, SystemException {
        ShoppingOrder order = this.shoppingOrderLocalService.getOrder(orderId);
        if (order.getUserId() == this.getUserId()) {
            return order;
        }
        ShoppingPermission.check(this.getPermissionChecker(), groupId, "MANAGE_ORDERS");
        return order;
    }

    public void sendEmail(long groupId, long orderId, String emailType, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingOrderPermission.check(this.getPermissionChecker(), groupId, orderId, "UPDATE");
        this.shoppingOrderLocalService.sendEmail(orderId, emailType, serviceContext);
    }

    public ShoppingOrder updateOrder(long groupId, long orderId, String ppTxnId, String ppPaymentStatus, double ppPaymentGross, String ppReceiverEmail, String ppPayerEmail) throws PortalException, SystemException {
        ShoppingOrderPermission.check(this.getPermissionChecker(), groupId, orderId, "UPDATE");
        return this.shoppingOrderLocalService.updateOrder(orderId, ppTxnId, ppPaymentStatus, ppPaymentGross, ppReceiverEmail, ppPayerEmail);
    }

    public ShoppingOrder updateOrder(long groupId, long orderId, String billingFirstName, String billingLastName, String billingEmailAddress, String billingCompany, String billingStreet, String billingCity, String billingState, String billingZip, String billingCountry, String billingPhone, boolean shipToBilling, String shippingFirstName, String shippingLastName, String shippingEmailAddress, String shippingCompany, String shippingStreet, String shippingCity, String shippingState, String shippingZip, String shippingCountry, String shippingPhone, String ccName, String ccType, String ccNumber, int ccExpMonth, int ccExpYear, String ccVerNumber, String comments) throws PortalException, SystemException {
        ShoppingOrderPermission.check(this.getPermissionChecker(), groupId, orderId, "UPDATE");
        return this.shoppingOrderLocalService.updateOrder(orderId, billingFirstName, billingLastName, billingEmailAddress, billingCompany, billingStreet, billingCity, billingState, billingZip, billingCountry, billingPhone, shipToBilling, shippingFirstName, shippingLastName, shippingEmailAddress, shippingCompany, shippingStreet, shippingCity, shippingState, shippingZip, shippingCountry, shippingPhone, ccName, ccType, ccNumber, ccExpMonth, ccExpYear, ccVerNumber, comments);
    }
}

