/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.model.BaseModel;
import java.lang.reflect.Method;
import java.util.List;

public class AlloyServiceInvoker {
    protected Method dynamicQueryCountMethod;
    protected Method dynamicQueryMethod1;
    protected Method dynamicQueryMethod2;
    protected Method dynamicQueryMethod3;
    protected Method dynamicQueryMethod4;
    protected Method fetchModelMethod;
    protected Method getModelsCountMethod;
    protected Method getModelsMethod;

    public AlloyServiceInvoker(String className) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        int pos = className.indexOf(".model.");
        String simpleClassName = className.substring(pos + 7);
        String serviceClassName = String.valueOf(className.substring(0, pos)) + ".service." + simpleClassName + "LocalServiceUtil";
        try {
            Class<?> serviceClass = classLoader.loadClass(serviceClassName);
            this.dynamicQueryCountMethod = serviceClass.getMethod("dynamicQueryCount", DynamicQuery.class);
            this.dynamicQueryMethod1 = serviceClass.getMethod("dynamicQuery", new Class[0]);
            this.dynamicQueryMethod2 = serviceClass.getMethod("dynamicQuery", DynamicQuery.class);
            this.dynamicQueryMethod3 = serviceClass.getMethod("dynamicQuery", DynamicQuery.class, Integer.TYPE, Integer.TYPE);
            this.dynamicQueryMethod4 = serviceClass.getMethod("dynamicQuery", DynamicQuery.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class);
            this.fetchModelMethod = serviceClass.getMethod("fetch" + simpleClassName, Long.TYPE);
            this.getModelsCountMethod = serviceClass.getMethod("get" + TextFormatter.formatPlural((String)simpleClassName) + "Count", new Class[0]);
            this.getModelsMethod = serviceClass.getMethod("get" + TextFormatter.formatPlural((String)simpleClassName), Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DynamicQuery buildDynamicQuery() throws Exception {
        return (DynamicQuery)this.dynamicQueryMethod1.invoke((Object)false, new Object[0]);
    }

    public DynamicQuery buildDynamicQuery(Object[] properties) throws Exception {
        if (properties.length == 0 || properties.length % 2 != 0) {
            throw new IllegalArgumentException("Properties length is not an even number");
        }
        DynamicQuery dynamicQuery = this.buildDynamicQuery();
        int i = 0;
        while (i < properties.length) {
            String propertyName = String.valueOf(properties[i]);
            Property property = PropertyFactoryUtil.forName((String)propertyName);
            Object propertyValue = properties[i + 1];
            dynamicQuery.add(property.eq(propertyValue));
            i += 2;
        }
        return dynamicQuery;
    }

    public List dynamicQuery(DynamicQuery dynamicQuery) throws Exception {
        return this.executeDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) throws Exception {
        return this.executeDynamicQueryCount(dynamicQuery);
    }

    public List executeDynamicQuery(DynamicQuery dynamicQuery) throws Exception {
        return (List)this.dynamicQueryMethod2.invoke((Object)false, dynamicQuery);
    }

    public List executeDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws Exception {
        return (List)this.dynamicQueryMethod3.invoke((Object)false, dynamicQuery, start, end);
    }

    public List executeDynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator obc) throws Exception {
        return (List)this.dynamicQueryMethod4.invoke((Object)false, dynamicQuery, start, end, obc);
    }

    public List executeDynamicQuery(Object[] properties) throws Exception {
        return this.executeDynamicQuery(this.buildDynamicQuery(properties));
    }

    public List executeDynamicQuery(Object[] properties, int start, int end) throws Exception {
        return this.executeDynamicQuery(this.buildDynamicQuery(properties), start, end);
    }

    public List executeDynamicQuery(Object[] properties, int start, int end, OrderByComparator obc) throws Exception {
        return this.executeDynamicQuery(this.buildDynamicQuery(properties), start, end, obc);
    }

    public long executeDynamicQueryCount(DynamicQuery dynamicQuery) throws Exception {
        return (Long)this.dynamicQueryCountMethod.invoke((Object)false, dynamicQuery);
    }

    public long executeDynamicQueryCount(Object[] properties) throws Exception {
        return this.executeDynamicQueryCount(this.buildDynamicQuery(properties));
    }

    public BaseModel<?> fetchModel(long classPK) throws Exception {
        return (BaseModel)this.fetchModelMethod.invoke((Object)false, classPK);
    }

    public List getModels(int start, int end) throws Exception {
        return (List)this.getModelsMethod.invoke((Object)false, start, end);
    }

    public int getModelsCount() throws Exception {
        return (Integer)this.getModelsCountMethod.invoke((Object)false, new Object[0]);
    }
}

