/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.gridfs.GridFSDBFile;
import java.io.InputStream;
import java.net.UnknownHostException;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Copy;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyOperator
extends Copy {
    final Logger logger = LoggerFactory.getLogger(CopyOperator.class);

    public CopyOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String originalDir = resource.getLocalDir();
        this.logger.debug("from directory: " + originalDir + "to directory: " + dir);
        String name = resource.getName();
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = resource.getOperation().getRemoteResource();
        ObjectId destinationId = null;
        this.logger.debug("copy operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source == null || source.isEmpty() || destination == null || destination.isEmpty()) throw new RemoteBackendException("Invalid arguments: source " + source + " destination " + destination);
        GridFSDBFile f = mongoPrimaryInstance.retrieveRemoteDescriptor(source, remoteResourceIdentifier, true);
        if (f != null) {
            f = mongoPrimaryInstance.retrieveLinkPayload(f);
            InputStream is = f.getInputStream();
            resource.setInputStream(is);
            GridFSDBFile dest = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, false);
            ObjectId removedId = null;
            if (dest != null) {
                removedId = mongoPrimaryInstance.removeFile(resource, null, resource.isReplace(), null, dest);
                destinationId = remoteResourceIdentifier != null && remoteResourceIdentifier.equals((Object)OperationDefinition.REMOTE_RESOURCE.ID) && removedId != null ? mongoPrimaryInstance.createNewFile(resource, null, dir, name, removedId) : mongoPrimaryInstance.createNewFile(resource, destination, dir, name, removedId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ObjectId: " + destinationId);
                }
                mongoPrimaryInstance.close();
                return destinationId.toString();
            } else {
                destinationId = mongoPrimaryInstance.createNewFile(resource, destination, dir, name, null);
                mongoPrimaryInstance.close();
            }
            return destinationId.toString();
        } else {
            mongoPrimaryInstance.close();
            throw new RemoteBackendException(" the source path is wrong. There isn't a file at " + source);
        }
    }

    public String safePut(MongoIOManager mongoPrimaryInstance, Object resource, String bucket, String key, boolean replace) throws UnknownHostException {
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = ((MyFile)resource).getOperation().getRemoteResource();
        this.logger.info("MongoClient put method: " + op.toString());
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        ObjectId id = null;
        ObjectId oldId = null;
        GridFSDBFile fold = mongoPrimaryInstance.retrieveRemoteDescriptor(bucket, remoteResourceIdentifier, false);
        if (fold != null) {
            this.logger.info("a file is already present at: " + bucket);
            oldId = (ObjectId)fold.getId();
            this.logger.info("get old id: " + oldId);
            id = mongoPrimaryInstance.createNewFile(resource, bucket, dir, name, null);
            oldId = mongoPrimaryInstance.removeFile(resource, key, replace, oldId, fold);
            id = mongoPrimaryInstance.updateId(id, oldId);
        } else {
            id = mongoPrimaryInstance.createNewFile(resource, bucket, dir, name, oldId);
        }
        return id.toString();
    }
}

