/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.net.UnknownHostException;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Link;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkOperator
extends Link {
    Logger logger = LoggerFactory.getLogger(LinkOperator.class);

    public LinkOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MongoIOManager mongoSecondaryInstance, MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        GridFSInputFile destinationFile;
        boolean replace = true;
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = resource.getOperation().getRemoteResource();
        String destinationId = null;
        String sourceId = null;
        this.logger.debug("link operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            int count;
            GridFSDBFile f = mongoPrimaryInstance.retrieveRemoteDescriptor(source, remoteResourceIdentifier, false);
            if (f != null) {
                count = 1;
                if (f.containsField("count") && f.get("count") != null) {
                    count = (Integer)f.get("count");
                    ++count;
                }
            } else {
                mongoPrimaryInstance.close();
                throw new IllegalArgumentException(" source remote file not found at: " + source);
            }
            f.put("count", (Object)count);
            mongoPrimaryInstance.updateCommonFields((DBObject)f, resource, OperationDefinition.OPERATION.LINK);
            sourceId = f.getId().toString();
            f.save();
            GridFSDBFile fold = mongoPrimaryInstance.retrieveRemoteDescriptor(destinationPath, remoteResourceIdentifier, false);
            if (fold != null) {
                String oldir = (String)fold.get("dir");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("old dir  found " + oldir);
                }
                if (oldir.equalsIgnoreCase(resource.getRemoteDir())) {
                    String lock;
                    ObjectId oldId = (ObjectId)fold.getId();
                    if (!replace) {
                        return oldId.toString();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("remove id: " + oldId);
                    }
                    if ((lock = (String)fold.get("lock")) != null && !lock.isEmpty() && !mongoPrimaryInstance.isTTLUnlocked(fold)) {
                        mongoPrimaryInstance.close();
                        throw new IllegalAccessError("The file is locked");
                    }
                    mongoPrimaryInstance.removeGFSFile(fold, oldId);
                }
            }
            destinationFile = null;
            byte[] data = new byte[1];
            destinationFile = resource.getGcubeMemoryType() == MemoryType.VOLATILE ? mongoPrimaryInstance.createGFSFileObject(data) : mongoPrimaryInstance.createGFSFileObject(data, resource.getWriteConcern(), resource.getReadPreference());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            mongoPrimaryInstance.setGenericProperties(resource, destinationPath, dir, destinationFile, name);
            destinationFile.put("link", (Object)sourceId);
            destinationId = destinationFile.getId().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + destinationId);
            }
        } else {
            mongoPrimaryInstance.close();
            throw new IllegalArgumentException(" invalid argument: source: " + source + " dest: " + destination + " the values must be not null and not empty");
        }
        mongoPrimaryInstance.buildDirTree(mongoPrimaryInstance.getMetaDataCollection(null), dir);
        destinationFile.save();
        mongoPrimaryInstance.close();
        return destinationId.toString();
    }
}

