/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.MoveDir;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoOperationManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.Costants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveDirOperator
extends MoveDir {
    Logger logger = LoggerFactory.getLogger(MoveDirOperator.class);

    public MoveDirOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public List<String> execute(MongoIOManager mongoPrimaryInstance, MyFile resource, String sourcePath, String destinationPath, MemoryType memoryType) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String parentFolder = this.extractParent(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        ArrayList<String> idList = null;
        this.logger.debug("moveDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), true);
            DBCollection meta = mongoPrimaryInstance.getMetaDataCollection(db);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"dir", (Object)new BasicDBObject("$regex", (Object)(source + "*")));
            DBCursor folderCursor = meta.find((DBObject)query);
            if (folderCursor != null) {
                idList = new ArrayList<String>();
                while (folderCursor.hasNext()) {
                    DBObject f = folderCursor.next();
                    if (!f.get("type").equals("file")) continue;
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    f.put("filename", (Object)filename);
                    f.put("dir", (Object)dir);
                    mongoPrimaryInstance.updateCommonFields(f, resource, OperationDefinition.OPERATION.MOVE_DIR);
                    String id = f.get("_id").toString();
                    idList.add(id);
                    query = new BasicDBObject();
                    query.put((Object)"_id", (Object)new ObjectId(id));
                    if (memoryType != MemoryType.VOLATILE) {
                        meta.update((DBObject)query, f, true, false, Costants.DEFAULT_WRITE_TYPE);
                    } else {
                        meta.update((DBObject)query, f, true, false);
                    }
                    mongoPrimaryInstance.buildDirTree(meta, dir);
                }
            }
        } else {
            mongoPrimaryInstance.close();
            throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
        }
        mongoPrimaryInstance.close();
        return idList;
    }
}

