/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.util.List;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.config.FieldConfig;
import org.apache.lucene.queryParser.core.config.QueryConfigHandler;
import org.apache.lucene.queryParser.core.nodes.BoostQueryNode;
import org.apache.lucene.queryParser.core.nodes.FieldableNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.core.util.StringUtils;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoostQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof FieldableNode && (node.getParent() == null || !(node.getParent() instanceof FieldableNode))) {
            Float boost;
            CharSequence field;
            FieldConfig fieldConfig;
            FieldableNode fieldNode = (FieldableNode)node;
            QueryConfigHandler config = this.getQueryConfigHandler();
            if (config != null && (fieldConfig = config.getFieldConfig(StringUtils.toString(field = fieldNode.getField()))) != null && (boost = fieldConfig.get(StandardQueryConfigHandler.ConfigurationKeys.BOOST)) != null) {
                return new BoostQueryNode(node, boost.floatValue());
            }
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

