/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.walluck.io.LittleEndianOutputStream;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.CapabilityBlock;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.Stat;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.handlers.directim.DirectIMHeader;
import org.walluck.oscar.handlers.filetransfer.FTTLV;
import org.walluck.oscar.handlers.filetransfer.FileHeader;
import org.walluck.oscar.handlers.filetransfer.GetFileEntry;
import org.walluck.oscar.handlers.filetransfer.GetFileList;
import org.walluck.oscar.handlers.icq.ICQColor;
import org.walluck.oscar.handlers.proxy.ProxyPacket;

public class AIMOutputStream
extends LittleEndianOutputStream {
    private ByteArrayOutputStream baos;

    public AIMOutputStream(OutputStream os) {
        super(os);
    }

    public AIMOutputStream() {
        this(128);
    }

    public AIMOutputStream(int size) {
        super(new ByteArrayOutputStream(size));
        this.baos = (ByteArrayOutputStream)this.out;
    }

    public void writeFLAP(FLAP flap) throws IOException {
        this.writeByte(flap.getCommand());
        this.writeByte(flap.getChannel());
        this.writeShort(flap.getSeqNum());
        this.writeShort(flap.getLength());
    }

    public void writeSNAC(SNAC snac) throws IOException {
        this.writeShort(snac.getFamily());
        this.writeShort(snac.getSubtype());
        this.writeShort(snac.getFlags());
        this.writeInt(snac.getId());
    }

    public void writeTLVChain(TLVChain tlvchain) throws IOException {
        int size = tlvchain.size();
        for (int i = 0; i < size; ++i) {
            TLV tlv = (TLV)tlvchain.get(i);
            this.writeShort(tlv.getType());
            this.writeShort(tlv.getLength());
            if (tlv.getLength() <= 0) continue;
            this.writeBytes(tlv.getValue());
        }
    }

    public void writeFTTLV(FTTLV fttlv) throws IOException {
        this.writeShort(fttlv.getSubtype());
        this.writeShort(fttlv.getNumFiles());
        this.writeInt((int)fttlv.getTotalSize());
        if (fttlv.getName() != null) {
            this.writeString0(AIMUtil.dirSysToAOL(fttlv.getName()));
        }
        this.writeShort(fttlv.getCharset());
        this.writeShort(fttlv.getCharSubset());
    }

    public void writeCaps(int caps) throws IOException {
        Iterator i = CapabilityBlock.getCapabilities().iterator();
        while (i.hasNext()) {
            CapabilityBlock cap = (CapabilityBlock)i.next();
            if ((caps & cap.getFlag()) == 0) continue;
            this.writeBytes(cap.getData());
        }
    }

    public void writeUserInfo(UserInfo info) throws IOException {
        this.writeByte(info.getSN().length());
        this.writeString(info.getSN());
        this.writeShort((short)info.getWarnLevel());
        TLVChain tlvchain = new TLVChain(8);
        tlvchain.addShort(1, info.getFlags());
        tlvchain.addInt(2, info.getMemberSince());
        tlvchain.addInt(3, info.getOnlineSince());
        tlvchain.addShort(4, info.getIdleTime());
        if (Character.isDigit(info.getSN().charAt(0))) {
            tlvchain.addShort(6, info.getIcqInfo().getStatus());
            tlvchain.addInt(10, info.getIcqInfo().getIP());
        }
        tlvchain.addCaps(13, info.getCapabilities());
        tlvchain.addInt((info.getFlags() & 4) != 0 ? 16 : 15, info.getSessionLen());
        this.writeShort(tlvchain.size());
        this.writeTLVChain(tlvchain);
    }

    public void writeStats(ArrayList stats, int type) throws IOException {
        for (int i = 0; i < stats.size(); ++i) {
            Stat stat = (Stat)stats.get(i);
            if (stat.getType() != type) continue;
            this.writeInt(stat.getId());
            this.writeShort(stat.getCount());
        }
    }

    public void writeDirectIMHeader(DirectIMHeader dh) throws IOException {
        this.writeString(dh.getMagic());
        this.writeShort(dh.getLength());
        this.writeShort(dh.getType());
        this.writeShort(dh.getUnknown());
        this.writeShort(0);
        this.writeBytes(dh.getCookie());
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(dh.getPayloadLength());
        this.writeShort(dh.getCharset());
        this.writeShort(dh.getCharSubset());
        this.writeShort(0);
        this.writeShort(dh.getFlags());
        this.writeShort(0);
        this.writeShort(0);
        this.writeStringNullPadded(dh.getSN(), 32);
        if (dh.getPayload() != null) {
            this.writeBytes(dh.getPayload());
        }
    }

    public void writeFileHeader(FileHeader fh) throws IOException {
        this.writeString(fh.getMagic());
        this.writeShort(fh.getLength());
        this.writeShort(fh.getType());
        this.writeBytes(fh.getCookie());
        this.writeShort(fh.getEncryption());
        this.writeShort(fh.getCompression());
        this.writeShort(fh.getTotalNumFiles());
        this.writeShort(fh.getNumFilesLeft());
        this.writeShort(fh.getTotalNumParts());
        this.writeShort(fh.getNumPartsLeft());
        this.writeInt((int)fh.getTotalFileSize());
        this.writeInt((int)fh.getFileSize());
        this.writeInt((int)fh.getFileTime());
        this.writeInt((int)fh.getChecksum());
        this.writeInt((int)fh.getResRecvdChecksum());
        this.writeInt((int)fh.getResSize());
        this.writeInt((int)fh.getResTime());
        this.writeInt((int)fh.getResChecksum());
        this.writeInt((int)fh.getNumRecvd());
        this.writeInt((int)fh.getRecvdChecksum());
        this.writeStringNullPadded(fh.getIDString(), 32);
        this.writeByte(fh.getFlag());
        this.writeByte(fh.getListNameOffset());
        this.writeByte(fh.getListSizeOffset());
        this.writeBytes(fh.getDummyBlock());
        this.writeBytes(fh.getMacFileInfo());
        this.writeShort(fh.getCharset());
        this.writeShort(fh.getCharSubset());
        this.writeStringNullPadded(AIMUtil.dirSysToAOL(fh.getName()), 64);
    }

    public void writeGetFileEntries(ArrayList files) throws IOException {
        int size = files.size();
        TLVChain tlvchain = new TLVChain(size * 6);
        for (int i = 0; i < size; ++i) {
            GetFileEntry gfe = (GetFileEntry)files.get(i);
            if (gfe.getLastmod() != -1L) {
                tlvchain.addInt(257, (int)gfe.getLastmod());
            }
            if (gfe.getFilesize() != -1L) {
                tlvchain.addInt(771, (int)gfe.getFilesize());
            }
            tlvchain.addShort(1285, 0);
            if (gfe.getFilename() != null) {
                tlvchain.addString(1028, AIMUtil.dirSysToAOL(gfe.getFilename()));
            }
            if (gfe.getFlags() != 0) {
                tlvchain.addInt(2304, gfe.getFlags());
            }
            tlvchain.addNull(2313);
        }
        this.writeTLVChain(tlvchain);
    }

    public void writeGetFileList(GetFileList gfl) throws IOException {
        this.writeString(gfl.getVersion());
        this.writeGetFileEntries(gfl.getFiles());
    }

    public void writeProxyPacket(ProxyPacket proxyPacket) throws IOException {
        this.writeShort(10 + proxyPacket.getData().length);
        this.writeShort(proxyPacket.getVersion());
        this.writeShort(proxyPacket.getType());
        this.writeInt(proxyPacket.getUnknown());
        this.writeShort(proxyPacket.getFlags());
        if (proxyPacket.getData() != null) {
            this.writeBytes(proxyPacket.getData());
        }
    }

    public void writeICQColor(ICQColor color) throws IOException {
        this.writeByte(color.getRed());
        this.writeByte(color.getBlue());
        this.writeByte(color.getGreen());
        this.writeByte(color.getZero());
    }

    public void writeICBM(byte[] cookie, short channel, String sn) throws IOException {
        this.writeBytes(cookie);
        this.writeShort(channel);
        this.writeStringL(sn);
    }

    public void writeRendezvous(Rendezvous rv) throws IOException {
        this.writeShort(rv.getType());
        this.writeBytes(rv.getCookie());
        this.writeCaps(rv.getService());
        if (rv.getServiceData() != null) {
            this.writeTLVChain(rv.getServiceData());
        }
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        return this.baos.toByteArray();
    }
}

