/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.components.BuddyList;
import org.walluck.oscar.components.Dialogs;
import org.walluck.oscar.components.Main;
import org.walluck.oscar.components.SessionManager;

final class BuddyListFrame
extends JFrame
implements WindowListener,
ActionListener {
    private BuddyList blist;
    private static BuddyListFrame frame;

    private BuddyListFrame() {
        this.setTitle("Daim - Buddy List");
        this.addWindowListener(this);
        this.buildUI();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("add_buddy")) {
            Dialogs.showAddBuddyDialog();
        } else if (evt.getActionCommand().equals("load_script")) {
            JFileChooser chooser = new JFileChooser();
            int retVal = chooser.showOpenDialog(frame);
            String scriptFile = null;
            if (retVal == 0) {
                try {
                    scriptFile = chooser.getSelectedFile().getCanonicalPath();
                    if (scriptFile != null) {
                        SessionManager.getSessions()[0].getScriptInterpreter().executeScriptFile(scriptFile);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        } else if (evt.getActionCommand().equals("quit")) {
            Main.exit();
        } else if (evt.getActionCommand().equals("remove_buddy")) {
            Object obj;
            TreePath path = this.blist.getSelectionPath();
            if (path != null && (obj = path.getLastPathComponent()) instanceof Buddy) {
                Dialogs.showRemoveBuddyDialog(((Buddy)obj).getName());
            }
        } else if (evt.getActionCommand().equals("set_info")) {
            Dialogs.showSetInfoDialog();
        } else if (evt.getActionCommand().equals("set_avail")) {
            Dialogs.showSetAvailMsgDialog();
        } else if (evt.getActionCommand().equals("set_away")) {
            Dialogs.showSetAwayMsgDialog();
        }
    }

    private void buildMenu() {
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        JMenu menu = new JMenu("Daim");
        menu.setMnemonic(68);
        mbar.add(menu);
        JMenuItem item = new JMenuItem("Add A Buddy", 65);
        item.setActionCommand("add_buddy");
        menu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Remove Buddy", 82);
        item.setActionCommand("remove_buddy");
        menu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Load Script");
        item.setActionCommand("load_script");
        menu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Quit", 81);
        item.setActionCommand("quit");
        menu.add(item);
        item.addActionListener(this);
        menu = new JMenu("Tools");
        menu.setMnemonic(84);
        mbar.add(menu);
        item = new JMenuItem("Set Info", 73);
        item.setActionCommand("set_info");
        menu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Set Available Message", 65);
        item.setActionCommand("set_avail");
        menu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Set Away Message", 87);
        item.setActionCommand("set_away");
        menu.add(item);
        item.addActionListener(this);
    }

    private void buildUI() {
        this.blist = new BuddyList();
        this.getContentPane().add((Component)new JScrollPane(this.blist), "Center");
        this.buildMenu();
    }

    public BuddyList getBuddyList() {
        return this.blist;
    }

    public static BuddyListFrame getBuddyListFrame() {
        if (frame == null) {
            frame = new BuddyListFrame();
        }
        return frame;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent evt) {
        Main.exit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent evt) {
    }
}

