/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.trilliansecureim;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.channel.rendezvous.TrillianSecureIMRendezvous;
import org.walluck.oscar.handlers.ICBMHandler;

public class TrillianSecureIM2 {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM2 == null ? (class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM2 = TrillianSecureIM2.class$("org.walluck.oscar.handlers.trilliansecureim.TrillianSecureIM2")) : class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM2).getName());
    private AIMSession sess;
    private String screenname;
    private static final BigInteger FIVE = new BigInteger("5");
    private Cipher encoder;
    private Cipher decoder;
    private BigInteger prime;
    private DHPrivateKey myPrivate;
    private DHPublicKey myPublic;
    private DHPublicKey peerPublic;
    private SecretKey sessionKey;
    private SecureRandom random;
    static /* synthetic */ Class class$org$walluck$oscar$handlers$trilliansecureim$TrillianSecureIM2;

    public TrillianSecureIM2(AIMSession sess, String screenname) {
        this.sess = sess;
        this.screenname = screenname;
        this.random = new SecureRandom();
    }

    private void initCiphers() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        LOG.debug((Object)"initCiphers: called");
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(this.myPrivate);
        ka.doPhase(this.peerPublic, true);
        SecretKey sessionKey = ka.generateSecret("Blowfish");
        byte[] ivb = new byte[8];
        this.random.nextBytes(ivb);
        IvParameterSpec ips = new IvParameterSpec(ivb);
        this.encoder = Cipher.getInstance("Blowfish/CFB64/NoPadding");
        this.encoder.init(1, (Key)sessionKey, ips);
        this.decoder = Cipher.getInstance("Blowfish/CFB64/NoPadding");
        this.decoder.init(2, (Key)sessionKey, ips);
    }

    public void end() {
        TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
        try {
            rv.setClose();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, this.screenname, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    private void genKeys() {
        LOG.debug((Object)"Generating public and private keys...");
        if (this.prime == null) {
            this.prime = new BigInteger(512, 64, this.random);
        }
        LOG.debug((Object)("Our PublicValue length=" + this.prime.bitLength()));
        DHParameterSpec dhps = new DHParameterSpec(this.prime, FIVE);
        KeyPair kp = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("DH");
            kpg.initialize(dhps);
            kp = kpg.genKeyPair();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        this.myPublic = (DHPublicKey)kp.getPublic();
        this.myPrivate = (DHPrivateKey)kp.getPrivate();
        LOG.debug((Object)("Generate keys formats: " + this.myPublic.getFormat() + "/" + this.myPrivate.getFormat()));
        LOG.debug((Object)("Key lengths: " + this.myPublic.getEncoded().length + "/" + this.myPrivate.getEncoded().length));
        LOG.debug((Object)(AIMUtil.byteArrayToHexString(this.myPrivate.getEncoded()) + "/" + AIMUtil.byteArrayToHexString(this.myPublic.getEncoded())));
    }

    public void sendRequest() throws IOException {
        this.genKeys();
        TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
        rv.setPrime(this.prime);
        rv.setPublicValue(this.myPublic.getY());
        rv.setRequest();
        ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
        im.sendRendezvous(this.sess, this.screenname, rv);
    }

    public void sendMsg(String msg) {
        TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
        if (msg == null) {
            LOG.warn((Object)"null msg, not sending");
            return;
        }
        try {
            byte[] mbytes = msg.getBytes("US-ASCII");
            byte[] b = new byte[mbytes.length + 8];
            System.arraycopy(mbytes, 0, b, 8, mbytes.length);
            byte[] encodedMessage = this.encoder.doFinal(b);
            rv.setMsg(encodedMessage);
            rv.setMsg();
            ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
            im.sendRendezvous(this.sess, this.screenname, rv);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        catch (IllegalBlockSizeException ibe) {
            LOG.error((Object)"IllegalBlockSizeException", (Throwable)ibe);
        }
        catch (BadPaddingException bpe) {
            LOG.error((Object)"BadPaddignException", (Throwable)bpe);
        }
    }

    public void handleSecureIM(IncomingIMCH2 args) {
        LOG.debug((Object)"handling TrillianSecureIMRendezvous...");
        IncomingIMCH2.TrillianEncryption te = args.getTrillianEncryption();
        if (te.getCmdType() == 0) {
            LOG.debug((Object)("Received Trillian SecureIM Request from " + this.screenname));
            try {
                LOG.debug((Object)("PublicValue length=" + te.getPrime().bitLength()));
                BigInteger tmp = new BigInteger(512, 64, this.random);
                tmp.subtract(tmp).add(te.getPrime());
                te.setPrime(tmp);
                LOG.debug((Object)("PublicValue length=" + te.getPrime().bitLength()));
                DHPublicKeySpec dhpks = new DHPublicKeySpec(te.getPublicValue(), te.getPrime(), FIVE);
                this.prime = te.getPrime();
                KeyFactory kf = KeyFactory.getInstance("DH");
                try {
                    LOG.debug((Object)"Trying to generate peer PublicKey...");
                    this.peerPublic = (DHPublicKey)kf.generatePublic(dhpks);
                }
                catch (InvalidKeySpecException ikse) {
                    LOG.error((Object)"InvalidKeySpecException", (Throwable)ikse);
                }
                this.genKeys();
                this.initCiphers();
                TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
                rv.setPublicValue(this.myPublic.getY());
                try {
                    rv.setAccept();
                    ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
                    im.sendRendezvous(this.sess, this.screenname, rv);
                }
                catch (IOException ioe) {
                    LOG.error((Object)"IOException", (Throwable)ioe);
                }
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
            catch (NoSuchPaddingException nspe) {
                LOG.error((Object)"NoSuchPaddingException", (Throwable)nspe);
            }
            catch (InvalidKeyException ike) {
                LOG.error((Object)"InvalidKeyException", (Throwable)ike);
            }
            catch (InvalidAlgorithmParameterException iape) {
                LOG.error((Object)"InvalidAlgorithmParameterException", (Throwable)iape);
            }
        } else if (te.getCmdType() == 1) {
            LOG.debug((Object)("Received Trillian SecureIm Accept from " + this.screenname));
            DHPublicKeySpec dhpks = new DHPublicKeySpec(te.getPublicValue(), this.prime, FIVE);
            try {
                KeyFactory kf = KeyFactory.getInstance("DH");
                LOG.debug((Object)"Trying to generate peer PublicKey...");
                this.peerPublic = (DHPublicKey)kf.generatePublic(dhpks);
            }
            catch (InvalidKeySpecException ikse) {
                LOG.error((Object)"InvalidKeySpecException", (Throwable)ikse);
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
            try {
                this.initCiphers();
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)nsae);
            }
            catch (NoSuchPaddingException nspe) {
                LOG.error((Object)"NoSuchPaddingException", (Throwable)nspe);
            }
            catch (InvalidKeyException ike) {
                LOG.error((Object)"InvalidKeyException", (Throwable)ike);
            }
            catch (InvalidAlgorithmParameterException iape) {
                LOG.error((Object)"InvalidAlgorithmParameterException", (Throwable)iape);
            }
            TrillianSecureIMRendezvous rv = new TrillianSecureIMRendezvous();
            try {
                rv.setBegin();
                ICBMHandler im = (ICBMHandler)this.sess.getHandler(4);
                im.sendRendezvous(this.sess, this.screenname, rv);
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
            }
        } else if (te.getCmdType() == 2) {
            LOG.debug((Object)("Received Trillian SecureIm Begin from " + this.screenname));
            LOG.debug((Object)("Started encrypted session with " + this.screenname));
        } else if (te.getCmdType() == 3) {
            LOG.debug((Object)("Received Trillian SecureIm Msg from " + this.screenname));
            byte[] encrypted = te.getMsg();
            LOG.debug((Object)("encrypted.length=" + encrypted.length));
            try {
                byte[] decoded = this.decoder.doFinal(encrypted);
                LOG.debug((Object)("decoded.length=" + decoded.length));
                if (decoded.length > 8) {
                    byte[] decoded2 = new byte[decoded.length - 8];
                    System.arraycopy(decoded, 8, decoded2, 0, decoded2.length);
                    te.setMsg(decoded2);
                } else {
                    LOG.warn((Object)("decoded.length=" + decoded.length + ", should be > 8"));
                    te.setMsg(decoded);
                }
                LOG.debug((Object)("decoded message from=" + this.screenname + ": " + new String(te.getMsg(), "US-ASCII")));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error((Object)"UnsupportedEncodingException", (Throwable)uee);
            }
            catch (IllegalBlockSizeException ibe) {
                LOG.error((Object)"IllegalBlockSizeException", (Throwable)ibe);
            }
            catch (BadPaddingException bpe) {
                LOG.error((Object)"BadPaddignException", (Throwable)bpe);
            }
        } else if (te.getCmdType() == 4) {
            LOG.debug((Object)("Received Trillian SecureIm Close from " + this.screenname));
            LOG.debug((Object)("Closed encryption session with " + this.screenname));
        }
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public byte[] getMyPrivate() {
        return this.myPrivate.getEncoded();
    }

    public byte[] getMyPublic() {
        return this.myPublic.getEncoded();
    }

    public byte[] getPeerPublic() {
        return this.peerPublic.getEncoded();
    }

    public byte[] getSessionKey() {
        return this.sessionKey.getEncoded();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

