/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.BasicType;
import flexjson.BeanProperty;
import flexjson.ChainedSet;
import flexjson.JSONSerializer;
import flexjson.OutputHandler;
import flexjson.Path;
import flexjson.PathExpression;
import flexjson.SerializationType;
import flexjson.TypeContext;
import flexjson.transformer.Transformer;
import flexjson.transformer.TypeTransformerMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONContext {
    private static ThreadLocal<JSONContext> context = new ThreadLocal<JSONContext>(){

        @Override
        protected JSONContext initialValue() {
            return new JSONContext();
        }
    };
    private String rootName;
    private OutputHandler out;
    private boolean prettyPrint = false;
    private Stack<TypeContext> typeContextStack = new Stack();
    private int indent = 0;
    private TypeTransformerMap typeTransformerMap;
    private Map<Path, Transformer> pathTransformerMap;
    private List<PathExpression> pathExpressions;
    private SerializationType serializationType = SerializationType.SHALLOW;
    private ChainedSet visits = new ChainedSet(Collections.EMPTY_SET);
    private LinkedList<Object> objectStack = new LinkedList();
    private Path path = new Path();
    private boolean commaWritePending;

    public void serializationType(SerializationType serializationType) {
        this.serializationType = serializationType;
    }

    public void transform(Object object) {
        Transformer transformer = this.getPathTransformer();
        if (transformer == null) {
            transformer = this.getTypeTransformer(object);
        }
        transformer.transform(object);
    }

    public Transformer getTransformer(Object object) {
        Transformer transformer = this.getPathTransformer();
        if (transformer == null) {
            transformer = this.getTypeTransformer(object);
        }
        return transformer;
    }

    private Transformer getPathTransformer() {
        return this.pathTransformerMap.get(this.path);
    }

    private Transformer getTypeTransformer(Object object) {
        return this.typeTransformerMap.getTransformer(object);
    }

    public void setTypeTransformers(TypeTransformerMap typeTransformerMap) {
        this.typeTransformerMap = typeTransformerMap;
    }

    public void setPathTransformers(Map<Path, Transformer> pathTransformerMap) {
        this.pathTransformerMap = pathTransformerMap;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void pushTypeContext(TypeContext contextEnum) {
        this.typeContextStack.push(contextEnum);
    }

    public void popTypeContext() {
        this.typeContextStack.pop();
    }

    public TypeContext peekTypeContext() {
        if (!this.typeContextStack.isEmpty()) {
            return this.typeContextStack.peek();
        }
        return null;
    }

    public void setOut(OutputHandler out) {
        this.out = out;
    }

    public OutputHandler getOut() {
        return this.out;
    }

    public void write(String value) {
        this.commitComma();
        TypeContext currentTypeContext = this.peekTypeContext();
        if (currentTypeContext != null && currentTypeContext.getBasicType() == BasicType.ARRAY) {
            this.writeIndent();
        }
        this.out.write(value);
    }

    public TypeContext writeOpenObject() {
        TypeContext currentTypeContext;
        this.commitComma();
        if (this.prettyPrint && (currentTypeContext = this.peekTypeContext()) != null && currentTypeContext.getBasicType() == BasicType.ARRAY) {
            this.writeIndent();
        }
        TypeContext typeContext = new TypeContext(BasicType.OBJECT);
        this.pushTypeContext(typeContext);
        this.out.write("{");
        if (this.prettyPrint) {
            this.indent += 4;
            this.out.write("\n");
        }
        return typeContext;
    }

    public void writeCloseObject() {
        this.discardComma();
        if (this.prettyPrint) {
            this.out.write("\n");
            this.indent -= 4;
            this.writeIndent();
        }
        this.out.write("}");
        this.popTypeContext();
    }

    public void writeName(String name) {
        this.commitComma();
        if (this.prettyPrint) {
            this.writeIndent();
        }
        if (name != null) {
            this.writeQuoted(name);
        } else {
            this.write("null");
        }
        this.out.write(":");
        if (this.prettyPrint) {
            this.out.write(" ");
        }
    }

    public void writeComma() {
        this.commaWritePending = true;
    }

    private void discardComma() {
        this.commaWritePending = false;
    }

    private void commitComma() {
        if (this.commaWritePending) {
            this.out.write(",");
            if (this.prettyPrint) {
                this.out.write("\n");
            }
            this.commaWritePending = false;
        }
    }

    public TypeContext writeOpenArray() {
        TypeContext currentTypeContext;
        this.commitComma();
        if (this.prettyPrint && (currentTypeContext = this.peekTypeContext()) != null && currentTypeContext.getBasicType() == BasicType.ARRAY) {
            this.writeIndent();
        }
        TypeContext typeContext = new TypeContext(BasicType.ARRAY);
        this.pushTypeContext(typeContext);
        this.out.write("[");
        if (this.prettyPrint) {
            this.indent += 4;
            this.out.write("\n");
        }
        return typeContext;
    }

    public void writeCloseArray() {
        this.discardComma();
        if (this.prettyPrint) {
            this.out.write("\n");
            this.indent -= 4;
            this.writeIndent();
        }
        this.out.write("]");
        this.popTypeContext();
    }

    public void writeIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.write(" ");
        }
    }

    public void writeQuoted(String value) {
        TypeContext currentTypeContext;
        this.commitComma();
        if (this.prettyPrint && (currentTypeContext = this.peekTypeContext()) != null && currentTypeContext.getBasicType() == BasicType.ARRAY) {
            this.writeIndent();
        }
        this.out.write("\"");
        int last = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                last = this.out.write(value, last, i, "\\\"");
                continue;
            }
            if (c == '\\') {
                last = this.out.write(value, last, i, "\\\\");
                continue;
            }
            if (c == '\b') {
                last = this.out.write(value, last, i, "\\b");
                continue;
            }
            if (c == '\f') {
                last = this.out.write(value, last, i, "\\f");
                continue;
            }
            if (c == '\n') {
                last = this.out.write(value, last, i, "\\n");
                continue;
            }
            if (c == '\r') {
                last = this.out.write(value, last, i, "\\r");
                continue;
            }
            if (c == '\t') {
                last = this.out.write(value, last, i, "\\t");
                continue;
            }
            if (!Character.isISOControl(c)) continue;
            last = this.out.write(value, last, i) + 1;
            this.unicode(c);
        }
        if (last < value.length()) {
            this.out.write(value, last, value.length());
        }
        this.out.write("\"");
    }

    private void unicode(char c) {
        this.out.write("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.out.write(String.valueOf(JSONSerializer.HEX[digit]));
            n <<= 4;
        }
    }

    public static JSONContext get() {
        return context.get();
    }

    public static void cleanup() {
        context.remove();
    }

    public ChainedSet getVisits() {
        return this.visits;
    }

    public void setVisits(ChainedSet visits) {
        this.visits = visits;
    }

    public LinkedList<Object> getObjectStack() {
        return this.objectStack;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPathExpressions(List<PathExpression> pathExpressions) {
        this.pathExpressions = pathExpressions;
    }

    public boolean isIncluded(BeanProperty prop) {
        PathExpression expression = this.matches(this.pathExpressions);
        if (expression != null) {
            return expression.isIncluded();
        }
        Boolean included = prop.isIncluded();
        if (included != null) {
            return included;
        }
        if (prop.isTransient().booleanValue()) {
            return false;
        }
        if (this.serializationType == SerializationType.SHALLOW) {
            Class propType = prop.getPropertyType();
            return !propType.isArray() && !Iterable.class.isAssignableFrom(propType) && !Map.class.isAssignableFrom(propType);
        }
        return true;
    }

    public boolean isIncluded(String key, Object value) {
        PathExpression expression = this.matches(this.pathExpressions);
        if (expression != null) {
            return expression.isIncluded();
        }
        String rootName = context.get().getRootName();
        if (value != null && (this.serializationType == SerializationType.SHALLOW && rootName != null && this.path.length() > 1 || this.serializationType == SerializationType.SHALLOW && rootName == null)) {
            Class<?> type = value.getClass();
            return !type.isArray() && !Iterable.class.isAssignableFrom(type);
        }
        return true;
    }

    protected PathExpression matches(List<PathExpression> expressions) {
        for (PathExpression expr : expressions) {
            if (!expr.matches(this.path)) continue;
            return expr;
        }
        return null;
    }
}

