/*
 * Decompiled with CFR 0.152.
 */
package flexjson.transformer;

import flexjson.JSONException;
import flexjson.ObjectBinder;
import flexjson.ObjectFactory;
import flexjson.transformer.AbstractTransformer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DateTransformer
extends AbstractTransformer
implements ObjectFactory {
    private String dateFormat;
    private ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal();

    public DateTransformer(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void transform(Object value) {
        this.getContext().writeQuoted(this.getFormatter().format(value));
    }

    public Object instantiate(ObjectBinder context, Object value, Type targetType, Class targetClass) {
        try {
            return this.getFormatter().parse(value.toString());
        }
        catch (ParseException e) {
            throw new JSONException(String.format("%s: Failed to parse %s with %s pattern.", context.getCurrentPath(), value, this.dateFormat), e);
        }
    }

    private SimpleDateFormat getFormatter() {
        if (this.formatter.get() == null) {
            this.formatter.set(new SimpleDateFormat(this.dateFormat));
        }
        return this.formatter.get();
    }
}

