/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.util.zip.ExtraField;
import de.schlichtherle.util.zip.LittleEndian;
import de.schlichtherle.util.zip.UShort;
import de.schlichtherle.util.zip.ZIP;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

final class ExtraFields
implements Cloneable {
    private Map extra = new TreeMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    ExtraFields() {
    }

    public Object clone() {
        try {
            ExtraFields clone = (ExtraFields)super.clone();
            clone.extra = new TreeMap(this.extra);
            return clone;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public int size() {
        return this.extra.size();
    }

    public ExtraField get(int headerID) {
        UShort.check(headerID);
        ExtraField ef = (ExtraField)this.extra.get(new Integer(headerID));
        if (!$assertionsDisabled && ef != null && headerID != ef.getHeaderID()) {
            throw new AssertionError();
        }
        return ef;
    }

    public ExtraField put(ExtraField ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        int headerID = ef.getHeaderID();
        UShort.check(headerID);
        return this.extra.put(new Integer(headerID), ef);
    }

    public ExtraField remove(int headerID) {
        UShort.check(headerID);
        ExtraField ef = (ExtraField)this.extra.remove(new Integer(headerID));
        if (!$assertionsDisabled && ef != null && headerID != ef.getHeaderID()) {
            throw new AssertionError();
        }
        return ef;
    }

    int getExtraLength() {
        if (this.extra.isEmpty()) {
            return 0;
        }
        int l = 0;
        Iterator it = this.extra.values().iterator();
        while (it.hasNext()) {
            ExtraField ef = (ExtraField)it.next();
            l += 4 + ef.getDataSize();
        }
        return l;
    }

    byte[] getExtra() {
        int size = this.getExtraLength();
        UShort.check(size);
        if (size == 0) {
            return ZIP.EMPTY;
        }
        byte[] data = new byte[size];
        this.writeTo(data, 0);
        return data;
    }

    void readFrom(byte[] data, int off, int size) {
        UShort.check(size, "Extra Field out of range", null);
        TreeMap<Integer, ExtraField> map = new TreeMap<Integer, ExtraField>();
        if (data != null && size > 0) {
            int end = off + size;
            while (off < end) {
                int headerID = LittleEndian.readUShort(data, off);
                int dataSize = LittleEndian.readUShort(data, off += 2);
                ExtraField ef = ExtraField.create(headerID);
                ef.readFrom(data, off += 2, dataSize);
                off += dataSize;
                map.put(new Integer(headerID), ef);
            }
            if (!$assertionsDisabled && off != end) {
                throw new AssertionError();
            }
        }
        this.extra = map;
    }

    void writeTo(byte[] data, int off) {
        Iterator it = this.extra.values().iterator();
        while (it.hasNext()) {
            ExtraField ef = (ExtraField)it.next();
            LittleEndian.writeShort(ef.getHeaderID(), data, off);
            LittleEndian.writeShort(ef.getDataSize(), data, off += 2);
            ef.writeTo(data, off += 2);
            off += ef.getDataSize();
        }
    }

    static {
        $assertionsDisabled = !ExtraFields.class.desiredAssertionStatus();
    }
}

