/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXCodeAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXClassAdapter
implements ClassVisitor {
    private ContentHandler h;
    private boolean singleDocument;

    public SAXClassAdapter(ContentHandler h, boolean singleDocument) {
        this.h = h;
        this.singleDocument = singleDocument;
        if (!singleDocument) {
            try {
                h.startDocument();
            }
            catch (SAXException ex) {
                throw new RuntimeException(ex.getException());
            }
        }
    }

    public final void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        try {
            StringBuffer sb = new StringBuffer();
            if ((access & 1) != 0) {
                sb.append("public ");
            }
            if ((access & 2) != 0) {
                sb.append("private ");
            }
            if ((access & 4) != 0) {
                sb.append("protected ");
            }
            if ((access & 0x10) != 0) {
                sb.append("final ");
            }
            if ((access & 0x20) != 0) {
                sb.append("super ");
            }
            if ((access & 0x200) != 0) {
                sb.append("interface ");
            }
            if ((access & 0x400) != 0) {
                sb.append("abstract ");
            }
            if ((access & 0x1000) != 0) {
                sb.append("synthetic ");
            }
            if ((access & 0x2000) != 0) {
                sb.append("annotation ");
            }
            if ((access & 0x4000) != 0) {
                sb.append("enum ");
            }
            if ((access & 0x20000) != 0) {
                sb.append("deprecated ");
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "access", "access", "", sb.toString());
            if (name != null) {
                attrs.addAttribute("", "name", "name", "", name);
            }
            if (superName != null) {
                attrs.addAttribute("", "parent", "parent", "", superName);
            }
            if (sourceFile != null) {
                attrs.addAttribute("", "source", "source", "", sourceFile);
            }
            attrs.addAttribute("", "major", "major", "", new Integer(version & 0xFFFF).toString());
            attrs.addAttribute("", "minor", "minor", "", new Integer(version >>> 16).toString());
            this.h.startElement("", "class", "class", attrs);
            this.h.startElement("", "interfaces", "interfaces", new AttributesImpl());
            if (interfaces != null && interfaces.length > 0) {
                int i = 0;
                while (i < interfaces.length) {
                    AttributesImpl attrs2 = new AttributesImpl();
                    attrs2.addAttribute("", "name", "name", "", interfaces[i]);
                    this.h.startElement("", "interface", "interface", attrs2);
                    this.h.endElement("", "interface", "interface");
                    ++i;
                }
            }
            this.h.endElement("", "interfaces", "interfaces");
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex.getException());
        }
    }

    public final void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        StringBuffer sb = new StringBuffer();
        if ((access & 1) != 0) {
            sb.append("public ");
        }
        if ((access & 2) != 0) {
            sb.append("private ");
        }
        if ((access & 4) != 0) {
            sb.append("protected ");
        }
        if ((access & 8) != 0) {
            sb.append("static ");
        }
        if ((access & 0x10) != 0) {
            sb.append("final ");
        }
        if ((access & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((access & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((access & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((access & 0x4000) != 0) {
            sb.append("enum ");
        }
        if ((access & 0x20000) != 0) {
            sb.append("deprecated ");
        }
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "access", "access", "", sb.toString());
        att.addAttribute("", "name", "name", "", name);
        att.addAttribute("", "desc", "desc", "", desc);
        if (value != null) {
            att.addAttribute("", "value", "value", "", SAXClassAdapter.encode(value.toString()));
        }
        try {
            this.h.startElement("", "field", "field", att);
            this.h.endElement("", "field", "field");
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public final CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        StringBuffer sb = new StringBuffer();
        if ((access & 1) != 0) {
            sb.append("public ");
        }
        if ((access & 2) != 0) {
            sb.append("private ");
        }
        if ((access & 4) != 0) {
            sb.append("protected ");
        }
        if ((access & 8) != 0) {
            sb.append("static ");
        }
        if ((access & 0x10) != 0) {
            sb.append("final ");
        }
        if ((access & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((access & 0x40) != 0) {
            sb.append("bridge ");
        }
        if ((access & 0x80) != 0) {
            sb.append("varargs ");
        }
        if ((access & 0x100) != 0) {
            sb.append("native ");
        }
        if ((access & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((access & 0x800) != 0) {
            sb.append("strict ");
        }
        if ((access & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((access & 0x20000) != 0) {
            sb.append("deprecated ");
        }
        try {
            AttributesImpl att = new AttributesImpl();
            att.addAttribute("", "access", "access", "", sb.toString());
            att.addAttribute("", "name", "name", "", name);
            att.addAttribute("", "desc", "desc", "", desc);
            this.h.startElement("", "method", "method", att);
            this.h.startElement("", "exceptions", "exceptions", new AttributesImpl());
            if (exceptions != null && exceptions.length > 0) {
                int i = 0;
                while (i < exceptions.length) {
                    AttributesImpl att2 = new AttributesImpl();
                    att2.addAttribute("", "name", "name", "", exceptions[i]);
                    this.h.startElement("", "exception", "exception", att2);
                    this.h.endElement("", "exception", "exception");
                    ++i;
                }
            }
            this.h.endElement("", "exceptions", "exceptions");
            if ((access & 0x700) > 0) {
                this.h.endElement("", "method", "method");
            } else {
                this.h.startElement("", "code", "code", new AttributesImpl());
            }
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex.toString());
        }
        return new SAXCodeAdapter(this.h);
    }

    public final void visitInnerClass(String name, String outerName, String innerName, int access) {
        StringBuffer sb = new StringBuffer();
        if ((access & 1) != 0) {
            sb.append("public ");
        }
        if ((access & 2) != 0) {
            sb.append("private ");
        }
        if ((access & 4) != 0) {
            sb.append("protected ");
        }
        if ((access & 8) != 0) {
            sb.append("static ");
        }
        if ((access & 0x10) != 0) {
            sb.append("final ");
        }
        if ((access & 0x20) != 0) {
            sb.append("super ");
        }
        if ((access & 0x200) != 0) {
            sb.append("interface ");
        }
        if ((access & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((access & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((access & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((access & 0x4000) != 0) {
            sb.append("enum ");
        }
        if ((access & 0x20000) != 0) {
            sb.append("deprecated ");
        }
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "access", "access", "", sb.toString());
            if (name != null) {
                attrs.addAttribute("", "name", "name", "", name);
            }
            if (outerName != null) {
                attrs.addAttribute("", "outerName", "outerName", "", outerName);
            }
            if (innerName != null) {
                attrs.addAttribute("", "innerName", "innerName", "", innerName);
            }
            this.h.startElement("", "innerclass", "innerclass", attrs);
            this.h.endElement("", "innerclass", "innerclass");
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public final void visitAttribute(Attribute attr) {
    }

    public final void visitEnd() {
        try {
            this.h.endElement("", "class", "class");
            if (!this.singleDocument) {
                this.h.endDocument();
            }
        }
        catch (SAXException ex) {
            ex.getException().printStackTrace();
            ex.printStackTrace();
            throw new RuntimeException(ex.toString());
        }
    }

    static final String encode(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
            } else if (c < ' ' || c > '\u007f') {
                sb.append("\\u");
                if (c < '\u0010') {
                    sb.append("000");
                } else if (c < '\u0100') {
                    sb.append("00");
                } else if (c < '\u1000') {
                    sb.append("0");
                }
                sb.append(Integer.toString(c, 16));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

