/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.linear;

import java.util.Collection;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math.optimization.linear.LinearOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinearOptimizer
implements LinearOptimizer {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    private int maxIterations;
    private int iterations;
    protected LinearObjectiveFunction f;
    protected Collection<LinearConstraint> constraints;
    protected GoalType goalType;
    protected boolean restrictToNonNegative;

    protected AbstractLinearOptimizer() {
        this.setMaxIterations(100);
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public int getIterations() {
        return this.iterations;
    }

    protected void incrementIterationsCounter() throws OptimizationException {
        if (++this.iterations > this.maxIterations) {
            throw new OptimizationException(new MaxIterationsExceededException(this.maxIterations));
        }
    }

    @Override
    public RealPointValuePair optimize(LinearObjectiveFunction f, Collection<LinearConstraint> constraints, GoalType goalType, boolean restrictToNonNegative) throws OptimizationException {
        this.f = f;
        this.constraints = constraints;
        this.goalType = goalType;
        this.restrictToNonNegative = restrictToNonNegative;
        this.iterations = 0;
        return this.doOptimize();
    }

    protected abstract RealPointValuePair doOptimize() throws OptimizationException;
}

