/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster.messaging;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLinkUtil;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;

public class ClusterBridgeMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(ClusterBridgeMessageListener.class);
    private boolean _active = true;
    private Priority _priority;

    public void setActive(boolean active) {
        this._active = active;
    }

    public void setPriority(Priority priority) {
        this._priority = priority;
    }

    @Override
    protected void doReceive(Message message) throws Exception {
        if (!this._active) {
            return;
        }
        if (ClusterLinkUtil.isForwardMessage(message)) {
            return;
        }
        Address address = ClusterLinkUtil.getAddress(message);
        if (address == null) {
            if (_log.isInfoEnabled()) {
                _log.info("Bridging cluster link multicast message " + message);
            }
            ClusterLinkUtil.sendMulticastMessage(message, this._priority);
        } else {
            if (_log.isInfoEnabled()) {
                _log.info("Bridging cluster link unicast message " + message + " to " + address);
            }
            ClusterLinkUtil.sendUnicastMessage(address, message, this._priority);
        }
    }
}

