/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jsonwebservice;

import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.MethodParametersResolverUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Set;

public class JSONWebServiceNaming {
    protected Set<String> excludedMethodNames = SetUtil.fromArray(new String[]{"getBeanIdentifier", "setBeanIdentifier"});
    protected String[] excludedPaths = PropsUtil.getArray("jsonws.web.service.paths.excludes");
    protected String[] excludedTypesNames = new String[]{InputStream.class.getName(), OutputStream.class.getName(), "javax."};
    protected String[] includedPaths = PropsUtil.getArray("jsonws.web.service.paths.includes");
    protected Set<String> invalidHttpMethods = SetUtil.fromArray(PropsUtil.getArray("jsonws.web.service.invalid.http.methods"));
    protected Set<String> prefixes = SetUtil.fromArray(new String[]{"get", "has", "is"});

    public String convertClassNameToPath(Class<?> clazz) {
        String className = clazz.getSimpleName();
        className = StringUtil.replace(className, "Impl", "");
        className = StringUtil.replace(className, "Service", "");
        return StringUtil.toLowerCase(className);
    }

    public String convertImplClassNameToUtilClassName(Class<?> implementationClass) {
        String implementationClassName = implementationClass.getName();
        if (implementationClassName.endsWith("Impl")) {
            implementationClassName = implementationClassName.substring(0, implementationClassName.length() - 4);
        }
        String utilClassName = String.valueOf(implementationClassName) + "Util";
        utilClassName = StringUtil.replace(utilClassName, ".impl.", ".");
        return utilClassName;
    }

    public String convertMethodNameToHttpMethod(Method method) {
        String methodName = method.getName();
        String methodNamePrefix = this.getMethodNamePrefix(methodName);
        if (this.prefixes.contains(methodNamePrefix)) {
            return "GET";
        }
        return "POST";
    }

    public String convertMethodNameToPath(Method method) {
        return CamelCaseUtil.fromCamelCase(method.getName());
    }

    public boolean isIncludedMethod(Method method) {
        if (this.excludedMethodNames != null && this.excludedMethodNames.contains(method.getName())) {
            return false;
        }
        if (this.excludedTypesNames == null) {
            return true;
        }
        MethodParameter[] methodParameters = MethodParametersResolverUtil.resolveMethodParameters(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            MethodParameter methodParameter = methodParameters[i];
            Class<?> parameterType = parameterTypes[i];
            if (parameterType.isArray()) {
                parameterType = parameterType.getComponentType();
            }
            String parameterTypeName = parameterType.getName();
            String[] stringArray = this.excludedTypesNames;
            int n = this.excludedTypesNames.length;
            int n2 = 0;
            while (n2 < n) {
                String excludedTypesName = stringArray[n2];
                String signature = methodParameter.getSignature();
                if (signature.contains("<")) {
                    String excludedName = String.valueOf('L') + excludedTypesName;
                    if (!excludedName.endsWith(".")) {
                        excludedName = excludedName.concat(";");
                    }
                    if (signature.contains(excludedName = StringUtil.replace(excludedName, '.', '/'))) {
                        return false;
                    }
                }
                if (parameterTypeName.startsWith(excludedTypesName)) {
                    return false;
                }
                ++n2;
            }
            ++i;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            returnType = returnType.getComponentType();
        }
        String returnTypeName = returnType.getName();
        String[] stringArray = this.excludedTypesNames;
        int n = this.excludedTypesNames.length;
        int n3 = 0;
        while (n3 < n) {
            String excludedTypesName = stringArray[n3];
            if (excludedTypesName.startsWith(returnTypeName)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isIncludedPath(String contextPath, String path) {
        String portalContextPath = PortalUtil.getPathContext();
        if (!contextPath.equals(portalContextPath)) {
            path = String.valueOf(contextPath) + "." + path.substring(1);
        }
        String[] stringArray = this.excludedPaths;
        int n = this.excludedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String excludedPath = stringArray[n2];
            if (StringUtil.wildcardMatches(path, excludedPath, '?', '*', '\\', false)) {
                return false;
            }
            ++n2;
        }
        if (this.includedPaths.length == 0) {
            return true;
        }
        stringArray = this.includedPaths;
        n = this.includedPaths.length;
        n2 = 0;
        while (n2 < n) {
            String includedPath = stringArray[n2];
            if (StringUtil.wildcardMatches(path, includedPath, '?', '*', '\\', false)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValidHttpMethod(String httpMethod) {
        return !this.invalidHttpMethods.contains(httpMethod);
    }

    protected String getMethodNamePrefix(String methodName) {
        int i = 0;
        while (i < methodName.length()) {
            if (Character.isUpperCase(methodName.charAt(i))) break;
            ++i;
        }
        return methodName.substring(0, i);
    }
}

