/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;

public class PortletResponseUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletResponseUtil.class);

    public static void sendFile(MimeResponse mimeResponse, String fileName, byte[] bytes) throws IOException {
        PortletResponseUtil.sendFile(null, mimeResponse, fileName, bytes);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, byte[] bytes, String contentType) throws IOException {
        PortletResponseUtil.sendFile(null, mimeResponse, fileName, bytes, contentType);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, InputStream inputStream) throws IOException {
        PortletResponseUtil.sendFile(null, mimeResponse, fileName, inputStream);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, InputStream inputStream, int contentLength, String contentType) throws IOException {
        PortletResponseUtil.sendFile(null, mimeResponse, fileName, inputStream, contentLength, contentType);
    }

    public static void sendFile(MimeResponse mimeResponse, String fileName, InputStream inputStream, String contentType) throws IOException {
        PortletResponseUtil.sendFile(null, mimeResponse, fileName, inputStream, contentType);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, byte[] bytes) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, bytes, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, byte[] bytes, String contentType) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, bytes, contentType, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, byte[] bytes, String contentType, String contentDispositionType) throws IOException {
        PortletResponseUtil.setHeaders(portletRequest, mimeResponse, fileName, contentType, contentDispositionType);
        PortletResponseUtil.write(mimeResponse, bytes);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, inputStream, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream, int contentLength, String contentType) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, inputStream, contentLength, contentType, null);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream, int contentLength, String contentType, String contentDispositionType) throws IOException {
        PortletResponseUtil.setHeaders(portletRequest, mimeResponse, fileName, contentType, contentDispositionType);
        PortletResponseUtil.write(mimeResponse, inputStream, contentLength);
    }

    public static void sendFile(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, InputStream inputStream, String contentType) throws IOException {
        PortletResponseUtil.sendFile(portletRequest, mimeResponse, fileName, inputStream, 0, contentType);
    }

    public static void write(MimeResponse mimeResponse, byte[] bytes) throws IOException {
        PortletResponseUtil.write(mimeResponse, bytes, 0, 0);
    }

    public static void write(MimeResponse mimeResponse, byte[] bytes, int offset, int contentLength) throws IOException {
        if (!mimeResponse.isCommitted()) {
            if (contentLength == 0) {
                contentLength = bytes.length;
            }
            if (mimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
                resourceResponse.setContentLength(contentLength);
            }
            OutputStream outputStream = mimeResponse.getPortletOutputStream();
            outputStream.write(bytes, offset, contentLength);
        }
    }

    public static void write(MimeResponse mimeResponse, byte[][] bytesArray) throws IOException {
        if (mimeResponse.isCommitted()) {
            return;
        }
        long contentLength = 0L;
        byte[][] byArray = bytesArray;
        int n = bytesArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] bytes = byArray[n2];
            contentLength += (long)bytes.length;
            ++n2;
        }
        if (mimeResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
            PortletResponseUtil.setContentLength(resourceResponse, contentLength);
        }
        OutputStream outputStream = mimeResponse.getPortletOutputStream();
        byte[][] byArray2 = bytesArray;
        int n3 = bytesArray.length;
        n = 0;
        while (n < n3) {
            byte[] bytes = byArray2[n];
            outputStream.write(bytes);
            ++n;
        }
    }

    public static void write(MimeResponse mimeResponse, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            long contentLength = fileChannel.size();
            if (mimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
                PortletResponseUtil.setContentLength(resourceResponse, contentLength);
            }
            fileChannel.transferTo(0L, contentLength, Channels.newChannel(mimeResponse.getPortletOutputStream()));
        }
        finally {
            fileChannel.close();
        }
    }

    public static void write(MimeResponse mimeResponse, InputStream inputStream) throws IOException {
        PortletResponseUtil.write(mimeResponse, inputStream, 0);
    }

    public static void write(MimeResponse mimeResponse, InputStream inputStream, int contentLength) throws IOException {
        OutputStream outputStream = null;
        try {
            if (mimeResponse.isCommitted()) {
                return;
            }
            if (contentLength > 0 && mimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)mimeResponse;
                resourceResponse.setContentLength(contentLength);
            }
            StreamUtil.transfer(inputStream, mimeResponse.getPortletOutputStream(), false);
        }
        finally {
            StreamUtil.cleanUp(inputStream, outputStream);
        }
    }

    public static void write(MimeResponse mimeResponse, String s) throws IOException {
        PortletResponseUtil.write(mimeResponse, s.getBytes("UTF-8"));
    }

    protected static void setContentLength(ResourceResponse response, long contentLength) {
        response.setProperty("Content-Length", String.valueOf(contentLength));
    }

    protected static void setHeaders(PortletRequest portletRequest, MimeResponse mimeResponse, String fileName, String contentType, String contentDispositionType) {
        String contentDispositionFileName;
        block11: {
            if (_log.isDebugEnabled()) {
                _log.debug("Sending file of type " + contentType);
            }
            if (Validator.isNotNull(contentType)) {
                mimeResponse.setContentType(contentType);
            }
            mimeResponse.setProperty("Cache-Control", "private");
            if (Validator.isNull(fileName)) {
                return;
            }
            contentDispositionFileName = "filename=\"" + fileName + "\"";
            boolean ascii = true;
            int i = 0;
            while (i < fileName.length()) {
                if (!Validator.isAscii(fileName.charAt(i))) {
                    ascii = false;
                    break;
                }
                ++i;
            }
            try {
                if (!ascii) {
                    String encodedFileName = HttpUtil.encodeURL(fileName, true);
                    HttpServletRequest request = PortalUtil.getHttpServletRequest(portletRequest);
                    contentDispositionFileName = BrowserSnifferUtil.isIe(request) ? "filename=\"" + encodedFileName + "\"" : "filename*=UTF-8''" + encodedFileName;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn(e);
            }
        }
        if (Validator.isNull(contentDispositionType)) {
            String extension = GetterUtil.getString(FileUtil.getExtension(fileName));
            extension = StringUtil.toLowerCase(extension);
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray("mime.types.content.disposition.inline");
            }
            catch (Exception exception) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            contentDispositionType = ArrayUtil.contains(mimeTypesContentDispositionInline, extension) ? "inline" : "attachment";
        }
        StringBundler sb = new StringBundler(4);
        sb.append(contentDispositionType);
        sb.append(";");
        sb.append(" ");
        sb.append(contentDispositionFileName);
        mimeResponse.setProperty("Content-Disposition", sb.toString());
    }
}

