/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SpellCheckIndexWriter;

public abstract class BaseIndexWriter
implements IndexWriter,
SpellCheckIndexWriter {
    private static Log _log = LogFactoryUtil.getLog(BaseIndexWriter.class);
    private SpellCheckIndexWriter _spellCheckIndexWriter;

    @Override
    public void clearQuerySuggestionDictionaryIndexes(SearchContext searchContext) throws SearchException {
        if (this._spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        this._spellCheckIndexWriter.clearQuerySuggestionDictionaryIndexes(searchContext);
    }

    @Override
    public void clearSpellCheckerDictionaryIndexes(SearchContext searchContext) throws SearchException {
        if (this._spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        this._spellCheckIndexWriter.clearSpellCheckerDictionaryIndexes(searchContext);
    }

    @Override
    public void indexKeyword(SearchContext searchContext, float weight, String keywordType) throws SearchException {
        if (this._spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        this._spellCheckIndexWriter.indexKeyword(searchContext, weight, keywordType);
    }

    @Override
    public void indexQuerySuggestionDictionaries(SearchContext searchContext) throws SearchException {
        if (this._spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        this._spellCheckIndexWriter.indexQuerySuggestionDictionaries(searchContext);
    }

    @Override
    public void indexQuerySuggestionDictionary(SearchContext searchContext) throws SearchException {
        if (this._spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        this._spellCheckIndexWriter.indexQuerySuggestionDictionary(searchContext);
    }

    @Override
    public void indexSpellCheckerDictionaries(SearchContext searchContext) throws SearchException {
        if (this._spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        this._spellCheckIndexWriter.indexSpellCheckerDictionaries(searchContext);
    }

    @Override
    public void indexSpellCheckerDictionary(SearchContext searchContext) throws SearchException {
        if (this._spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        this._spellCheckIndexWriter.indexSpellCheckerDictionary(searchContext);
    }

    public void setSpellCheckIndexWriter(SpellCheckIndexWriter spellCheckIndexWriter) {
        this._spellCheckIndexWriter = spellCheckIndexWriter;
    }
}

