/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

public class CamelCaseUtil {
    public static String fromCamelCase(String s) {
        return CamelCaseUtil.fromCamelCase(s, '-');
    }

    public static String fromCamelCase(String s, char delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                if (!upperCase || i < s.length() - 1 && !Character.isUpperCase(s.charAt(i + 1))) {
                    sb.append(delimiter);
                }
                c = Character.toLowerCase(c);
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String normalizeCamelCase(String s) {
        return CamelCaseUtil.normalizeCamelCase(s, false);
    }

    public static String normalizeCamelCase(String s, boolean normalizeInnerTerms) {
        StringBuilder sb = new StringBuilder(s);
        boolean upperCase = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!normalizeInnerTerms && c == '.') {
                return sb.toString();
            }
            if (i > 0 && Character.isUpperCase(c)) {
                char nextChar;
                boolean nextUpperCase = true;
                if (i < s.length() - 1 && (nextChar = s.charAt(i + 1)) != '.' && !Character.isUpperCase(nextChar)) {
                    nextUpperCase = false;
                }
                if (upperCase && nextUpperCase) {
                    sb.setCharAt(i, Character.toLowerCase(c));
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toCamelCase(String s) {
        return CamelCaseUtil.toCamelCase(s, '-');
    }

    public static String toCamelCase(String s, char delimiter) {
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == delimiter) {
                upperCase = true;
            } else if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

