/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class CentralizedThreadLocal<T>
extends ThreadLocal<T> {
    private static final int _HASH_INCREMENT = 1640531527;
    private static final Set<Class<?>> _immutableTypes = new HashSet();
    private static final AtomicInteger _longLivedNextHasCode;
    private static final ThreadLocal<ThreadLocalMap> _longLivedThreadLocals;
    private static final AtomicInteger _shortLivedNextHasCode;
    private static final ThreadLocal<ThreadLocalMap> _shortLivedThreadLocals;
    private final int _hashCode;
    private final boolean _shortLived;

    static {
        _immutableTypes.add(Boolean.class);
        _immutableTypes.add(Byte.class);
        _immutableTypes.add(Character.class);
        _immutableTypes.add(Short.class);
        _immutableTypes.add(Integer.class);
        _immutableTypes.add(Long.class);
        _immutableTypes.add(Float.class);
        _immutableTypes.add(Double.class);
        _immutableTypes.add(String.class);
        _longLivedNextHasCode = new AtomicInteger();
        _longLivedThreadLocals = new ThreadLocalMapThreadLocal();
        _shortLivedNextHasCode = new AtomicInteger();
        _shortLivedThreadLocals = new ThreadLocalMapThreadLocal();
    }

    public static void clearLongLivedThreadLocals() {
        _longLivedThreadLocals.remove();
    }

    public static void clearShortLivedThreadLocals() {
        _shortLivedThreadLocals.remove();
    }

    public static Map<CentralizedThreadLocal<?>, Object> getLongLivedThreadLocals() {
        return CentralizedThreadLocal._toMap(_longLivedThreadLocals.get());
    }

    public static Map<CentralizedThreadLocal<?>, Object> getShortLivedThreadLocals() {
        return CentralizedThreadLocal._toMap(_shortLivedThreadLocals.get());
    }

    public static void setThreadLocals(Map<CentralizedThreadLocal<?>, Object> longLivedThreadLocals, Map<CentralizedThreadLocal<?>, Object> shortLivedThreadLocals) {
        ThreadLocalMap threadLocalMap = _longLivedThreadLocals.get();
        for (Map.Entry<CentralizedThreadLocal<?>, Object> entry : longLivedThreadLocals.entrySet()) {
            threadLocalMap.putEntry(entry.getKey(), entry.getValue());
        }
        threadLocalMap = _shortLivedThreadLocals.get();
        for (Map.Entry<CentralizedThreadLocal<?>, Object> entry : shortLivedThreadLocals.entrySet()) {
            threadLocalMap.putEntry(entry.getKey(), entry.getValue());
        }
    }

    public CentralizedThreadLocal(boolean shortLived) {
        this._shortLived = shortLived;
        this._hashCode = shortLived ? _shortLivedNextHasCode.getAndAdd(1640531527) : _longLivedNextHasCode.getAndAdd(1640531527);
    }

    @Override
    public T get() {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        Entry entry = threadLocalMap.getEntry(this);
        if (entry == null) {
            Object value = this.initialValue();
            threadLocalMap.putEntry(this, value);
            return value;
        }
        return (T)entry._value;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public void remove() {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        threadLocalMap.removeEntry(this);
    }

    @Override
    public void set(T value) {
        ThreadLocalMap threadLocalMap = this._getThreadLocalMap();
        threadLocalMap.putEntry(this, value);
    }

    protected T copy(T value) {
        Class<?> clazz;
        if (value != null && _immutableTypes.contains(clazz = value.getClass())) {
            return value;
        }
        return null;
    }

    private static Map<CentralizedThreadLocal<?>, Object> _toMap(ThreadLocalMap threadLocalMap) {
        HashMap map = new HashMap(threadLocalMap._table.length);
        Entry[] entryArray = threadLocalMap._table;
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CentralizedThreadLocal centralizedThreadLocal;
            Object value;
            Entry entry = entryArray[n2];
            if (entry != null && (value = (centralizedThreadLocal = entry._key).copy(entry._value)) != null) {
                map.put(centralizedThreadLocal, value);
            }
            ++n2;
        }
        return map;
    }

    private ThreadLocalMap _getThreadLocalMap() {
        if (this._shortLived) {
            return _shortLivedThreadLocals.get();
        }
        return _longLivedThreadLocals.get();
    }

    private static class Entry {
        private CentralizedThreadLocal<?> _key;
        private Entry _next;
        private Object _value;

        public Entry(CentralizedThreadLocal<?> key, Object value, Entry next) {
            this._key = key;
            this._value = value;
            this._next = next;
        }
    }

    private static class ThreadLocalMap {
        private static final int _INITIAL_CAPACITY = 16;
        private static final int _MAXIMUM_CAPACITY = 0x40000000;
        private int _size;
        private Entry[] _table = new Entry[16];
        private int _threshold = 10;

        private ThreadLocalMap() {
        }

        public void expand(int newCapacity) {
            if (this._table.length == 0x40000000) {
                this._threshold = Integer.MAX_VALUE;
                return;
            }
            Entry[] newTable = new Entry[newCapacity];
            int i = 0;
            while (i < this._table.length) {
                Entry entry = this._table[i];
                if (entry != null) {
                    Entry nextEntry;
                    this._table[i] = null;
                    do {
                        nextEntry = entry._next;
                        int index = ((CentralizedThreadLocal)entry._key)._hashCode & newCapacity - 1;
                        entry._next = newTable[index];
                        newTable[index] = entry;
                    } while ((entry = nextEntry) != null);
                }
                ++i;
            }
            this._table = newTable;
            this._threshold = newCapacity * 2 / 3;
        }

        /*
         * Unable to fully structure code
         */
        public Entry getEntry(CentralizedThreadLocal<?> key) {
            index = CentralizedThreadLocal.access$0(key) & this._table.length - 1;
            entry = this._table[index];
            if (entry == null) {
                return null;
            }
            if (Entry.access$1(entry) != key) ** GOTO lbl9
            return entry;
lbl-1000:
            // 1 sources

            {
                if (Entry.access$1(entry) != key) continue;
                return entry;
lbl9:
                // 2 sources

                ** while ((entry = Entry.access$0((Entry)entry)) != null)
            }
lbl10:
            // 1 sources

            return null;
        }

        public void putEntry(CentralizedThreadLocal<?> key, Object value) {
            int index = ((CentralizedThreadLocal)key)._hashCode & this._table.length - 1;
            Entry entry = this._table[index];
            while (entry != null) {
                if (entry._key == key) {
                    entry._value = value;
                    return;
                }
                entry = entry._next;
            }
            this._table[index] = new Entry(key, value, this._table[index]);
            if (this._size++ >= this._threshold) {
                this.expand(2 * this._table.length);
            }
        }

        public void removeEntry(CentralizedThreadLocal<?> key) {
            int index = ((CentralizedThreadLocal)key)._hashCode & this._table.length - 1;
            Entry previousEntry = null;
            Entry entry = this._table[index];
            while (entry != null) {
                Entry nextEntry = entry._next;
                if (entry._key == key) {
                    --this._size;
                    if (previousEntry == null) {
                        this._table[index] = nextEntry;
                    } else {
                        previousEntry._next = nextEntry;
                    }
                    return;
                }
                previousEntry = entry;
                entry = nextEntry;
            }
        }
    }

    private static class ThreadLocalMapThreadLocal
    extends ThreadLocal<ThreadLocalMap> {
        private ThreadLocalMapThreadLocal() {
        }

        @Override
        protected ThreadLocalMap initialValue() {
            return new ThreadLocalMap();
        }
    }
}

