/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.Validator;

public class JavaDetector {
    private static final String _JAVA_VERSION_JDK_4 = "1.4.";
    private static final String _JAVA_VERSION_JDK_5 = "1.5.";
    private static final String _JAVA_VERSION_JDK_6 = "1.6.";
    private static final String _JAVA_VERSION_JDK_7 = "1.7.";
    private static Log _log = LogFactoryUtil.getLog(JavaDetector.class);
    private static JavaDetector _instance = new JavaDetector();
    private boolean _64bit;
    private boolean _ibm;
    private String _javaClassPath = System.getProperty("java.class.path");
    private double _javaClassVersion = GetterUtil.getDouble(System.getProperty("java.class.version"));
    private String _javaRuntimeName = System.getProperty("java.runtime.name");
    private String _javaRuntimeVersion = System.getProperty("java.runtime.version");
    private double _javaSpecificationVersion = GetterUtil.getDouble(System.getProperty("java.specification.version"));
    private String _javaVendor = System.getProperty("java.vendor");
    private String _javaVersion = System.getProperty("java.version");
    private String _javaVmVersion = System.getProperty("java.vm.version");
    private boolean _openJDK;

    public static String getJavaClassPath() {
        return JavaDetector._instance._javaClassPath;
    }

    public static double getJavaClassVersion() {
        return JavaDetector._instance._javaClassVersion;
    }

    public static String getJavaRuntimeName() {
        return JavaDetector._instance._javaRuntimeName;
    }

    public static String getJavaRuntimeVersion() {
        return JavaDetector._instance._javaRuntimeVersion;
    }

    public static double getJavaSpecificationVersion() {
        return JavaDetector._instance._javaSpecificationVersion;
    }

    public static String getJavaVendor() {
        return JavaDetector._instance._javaVendor;
    }

    public static String getJavaVersion() {
        return JavaDetector._instance._javaVersion;
    }

    public static String getJavaVmVersion() {
        return JavaDetector._instance._javaVmVersion;
    }

    public static boolean is64bit() {
        return JavaDetector._instance._64bit;
    }

    public static boolean isIBM() {
        return JavaDetector._instance._ibm;
    }

    public static boolean isJDK4() {
        String javaVersion = JavaDetector.getJavaVersion();
        return javaVersion.startsWith(_JAVA_VERSION_JDK_4);
    }

    public static boolean isJDK5() {
        String javaVersion = JavaDetector.getJavaVersion();
        return javaVersion.startsWith(_JAVA_VERSION_JDK_5);
    }

    public static boolean isJDK6() {
        String javaVersion = JavaDetector.getJavaVersion();
        return javaVersion.startsWith(_JAVA_VERSION_JDK_6);
    }

    public static boolean isJDK7() {
        String javaVersion = JavaDetector.getJavaVersion();
        return javaVersion.startsWith(_JAVA_VERSION_JDK_7);
    }

    public static boolean isOpenJDK() {
        return JavaDetector._instance._openJDK;
    }

    protected JavaDetector() {
        this._64bit = Validator.equals("64", System.getProperty("sun.arch.data.model"));
        if (this._javaVendor != null) {
            this._ibm = this._javaVendor.startsWith("IBM");
        }
        if (this._javaRuntimeName != null) {
            this._openJDK = this._javaRuntimeName.contains("OpenJDK");
        }
        if (_log.isDebugEnabled()) {
            LogUtil.debug(_log, new SortedProperties(System.getProperties()));
        }
    }
}

