/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.portletfilerepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Repository;
import com.liferay.portal.portletfilerepository.PortletFileRepository;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class PortletFileRepositoryUtil {
    private static PortletFileRepository _portletFileRepository;

    public static void addPortletFileEntries(long groupId, long userId, String className, long classPK, String portletId, long folderId, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().addPortletFileEntries(groupId, userId, className, classPK, portletId, folderId, inputStreamOVPs);
    }

    public static FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, File file, String fileName, String mimeType, boolean indexingEnabled) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, file, fileName, mimeType, indexingEnabled);
    }

    public static FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, InputStream inputStream, String fileName, String mimeType, boolean indexingEnabled) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, inputStream, fileName, mimeType, indexingEnabled);
    }

    public static Folder addPortletFolder(long userId, long repositoryId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().addPortletFolder(userId, repositoryId, parentFolderId, folderName, serviceContext);
    }

    public static Repository addPortletRepository(long groupId, String portletId, ServiceContext serviceContext) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().addPortletRepository(groupId, portletId, serviceContext);
    }

    public static void deleteFolder(long folderId) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().deleteFolder(folderId);
    }

    public static void deletePortletFileEntries(long groupId, long folderId) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().deletePortletFileEntries(groupId, folderId);
    }

    public static void deletePortletFileEntries(long groupId, long folderId, int status) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().deletePortletFileEntries(groupId, folderId, status);
    }

    public static void deletePortletFileEntry(long fileEntryId) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().deletePortletFileEntry(fileEntryId);
    }

    public static void deletePortletFileEntry(long groupId, long folderId, String fileName) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().deletePortletFileEntry(groupId, folderId, fileName);
    }

    public static void deletePortletRepository(long groupId, String portletId) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().deletePortletRepository(groupId, portletId);
    }

    public static Repository fetchPortletRepository(long groupId, String portletId) throws SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().fetchPortletRepository(groupId, portletId);
    }

    public static List<FileEntry> getPortletFileEntries(long groupId, long folderId) throws SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntries(groupId, folderId);
    }

    public static List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status) throws SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntries(groupId, folderId, status);
    }

    public static List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntries(groupId, folderId, status, start, end, obc);
    }

    public static int getPortletFileEntriesCount(long groupId, long folderId) throws SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntriesCount(groupId, folderId);
    }

    public static int getPortletFileEntriesCount(long groupId, long folderId, int status) throws SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntriesCount(groupId, folderId, status);
    }

    public static FileEntry getPortletFileEntry(long fileEntryId) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntry(fileEntryId);
    }

    public static FileEntry getPortletFileEntry(long groupId, long folderId, String fileName) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntry(groupId, folderId, fileName);
    }

    public static FileEntry getPortletFileEntry(String uuid, long groupId) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntry(uuid, groupId);
    }

    public static String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString) {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntryURL(themeDisplay, fileEntry, queryString);
    }

    public static String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString, boolean absoluteURL) {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFileEntryURL(themeDisplay, fileEntry, queryString, absoluteURL);
    }

    public static PortletFileRepository getPortletFileRepository() {
        PortalRuntimePermission.checkGetBeanProperty(PortletFileRepositoryUtil.class);
        return _portletFileRepository;
    }

    public static Folder getPortletFolder(long folderId) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFolder(folderId);
    }

    public static Folder getPortletFolder(long userId, long repositoryId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletFolder(repositoryId, parentFolderId, folderName);
    }

    public static Repository getPortletRepository(long groupId, String portletId) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().getPortletRepository(groupId, portletId);
    }

    public static FileEntry movePortletFileEntryToTrash(long userId, long fileEntryId) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().movePortletFileEntryToTrash(userId, fileEntryId);
    }

    public static FileEntry movePortletFileEntryToTrash(long groupId, long userId, long folderId, String fileName) throws PortalException, SystemException {
        return PortletFileRepositoryUtil.getPortletFileRepository().movePortletFileEntryToTrash(groupId, userId, folderId, fileName);
    }

    public static void restorePortletFileEntryFromTrash(long userId, long fileEntryId) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().restorePortletFileEntryFromTrash(userId, fileEntryId);
    }

    public static void restorePortletFileEntryFromTrash(long groupId, long userId, long folderId, String fileName) throws PortalException, SystemException {
        PortletFileRepositoryUtil.getPortletFileRepository().restorePortletFileEntryFromTrash(groupId, userId, folderId, fileName);
    }

    public void setPortletFileRepository(PortletFileRepository portletFileRepository) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _portletFileRepository = portletFileRepository;
    }
}

