/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryEntity;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class RemoteResource
extends Resource {
    TransportManager tm;

    public RemoteResource(MyFile file, ServiceEngine engine) {
        super(file, engine);
        this.logger.info("file gCube parameter costructor: " + (Object)((Object)file.getGcubeAccessType()) + " " + file.getGcubeScope());
    }

    public String RFile(String path) throws RemoteBackendException {
        return this.RFile(path, false);
    }

    public String RFile(String path, boolean backendTypeReturned) throws RemoteBackendException {
        this.logger.info("file gCube parameter before: " + (Object)((Object)this.file.getGcubeAccessType()) + " " + this.file.getGcubeScope());
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        Object obj = this.getRemoteObject(this.getMyFile(), this.engine.primaryBackend, this.engine.volatileBackend);
        String id = null;
        if (obj != null) {
            id = obj.toString();
        }
        if (backendTypeReturned && id != null) {
            return id + "%" + this.engine.getBackendType();
        }
        return id;
    }

    public String RFileById(String id) throws RemoteBackendException {
        return this.RFileById(id, false);
    }

    public String RFileById(String id, boolean backendTypeReturned) throws RemoteBackendException {
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.ID);
        Object obj = this.executeOperation(id);
        String idReturned = null;
        if (obj != null) {
            idReturned = obj.toString();
        }
        if (backendTypeReturned && idReturned != null) {
            return idReturned + "%" + this.engine.getBackendType();
        }
        return idReturned;
    }

    public List<StorageObject> RDir(String dir) {
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.DIR);
        this.getMyFile().setOwner(this.engine.owner);
        if (this.engine.getCurrentOperation().equalsIgnoreCase("showdir")) {
            dir = new BucketCoding().bucketDirCoding(dir, this.engine.getContext());
            TransportManagerFactory tmf = new TransportManagerFactory(this.engine.primaryBackend, this.engine.getBackendUser(), this.engine.getBackendPassword());
            this.tm = tmf.getTransport(this.tm, this.engine.getBackendType(), this.engine.getGcubeMemoryType(), this.engine.getDbNames(), this.engine.getWriteConcern(), this.engine.getReadConcern());
            Map<String, StorageObject> mapDirs = null;
            try {
                mapDirs = this.tm.getValues(this.getMyFile(), dir, DirectoryEntity.class);
            }
            catch (RemoteBackendException e) {
                e.printStackTrace();
            }
            List<StorageObject> dirs = null;
            if (mapDirs != null) {
                dirs = this.engine.addObjectsDirBucket(mapDirs);
            }
            if (dirs == null) {
                dirs = Collections.emptyList();
            }
            return dirs;
        }
        if (this.engine.getCurrentOperation().equalsIgnoreCase("removedir")) {
            if (dir != null && this.engine.owner != null) {
                DirectoryBucket dirBuc = new DirectoryBucket(this.engine.primaryBackend, this.engine.getBackendUser(), this.engine.getBackendPassword(), dir, this.engine.owner);
                if (!"mongo".equalsIgnoreCase("mongo")) {
                    dirBuc.removeDirBucket(this.getMyFile(), dir, this.engine.getContext(), this.engine.getBackendType(), this.engine.getDbNames());
                } else {
                    TransportManagerFactory tmf = new TransportManagerFactory(this.engine.primaryBackend, this.engine.getBackendUser(), this.engine.getBackendPassword());
                    this.tm = tmf.getTransport(this.tm, "mongo", this.engine.getGcubeMemoryType(), this.engine.getDbNames(), this.engine.getWriteConcern(), this.engine.getReadConcern());
                    dir = new BucketCoding().bucketFileCoding(dir, this.engine.getContext());
                    try {
                        this.tm.removeDir(dir, this.getMyFile());
                    }
                    catch (UnknownHostException e) {
                        throw new RemoteBackendException(e.getMessage());
                    }
                }
            } else {
                this.logger.error("REMOVE Operation not valid:\n\t specify a valid bucketID or an author and a path on the cluster ");
            }
            return null;
        }
        throw new IllegalArgumentException("The method RDir is not applicable for the operation selected");
    }
}

