/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.IOException;
import java.io.OutputStream;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Download
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    protected String localPath;
    protected String remotePath;
    protected OutputStream os;
    protected MyFile resource;

    public Download(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.localPath = file.getLocalPath();
        this.remotePath = remotePath;
        this.setResource(file);
        return this.getRemoteIdentifier(remotePath, rootArea);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        String id = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getRemotePath() + " in bucket: " + this.getBucket());
        }
        try {
            id = this.get(this, myFile, false);
        }
        catch (Throwable e) {
            TransportManager tm = this.getTransport(myFile);
            tm.close();
            this.logger.error("Problem in download from: " + myFile.getRemotePath() + ": " + e.getMessage());
            throw new RemoteBackendException(" Problem in download operation ", e.getCause());
        }
        return id;
    }

    @Override
    public String initOperation(MyFile resource, String remotePath, String author, String[] server, String rootArea) {
        String bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        this.os = resource.getOutputStream();
        this.setBucket(bucketName);
        return bucketName;
    }

    public abstract ObjectId execute(MongoIOManager var1, MongoIOManager var2) throws IOException;

    public MyFile getResource() {
        return this.resource;
    }

    public void setResource(MyFile resource) {
        this.resource = resource;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public OutputStream getOs() {
        return this.os;
    }

    public void setOs(OutputStream os) {
        this.os = os;
    }
}

