/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.util;

import com.mongodb.MongoClient;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class MongoInputStream
extends ProxyInputStream {
    private MongoClient mongo;
    private boolean closed;

    public MongoInputStream(MongoClient mongo, InputStream proxy) {
        super(proxy);
        this.mongo = mongo;
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                super.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setClosed(true);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            this.close();
        }
        return n;
    }

    public int read(byte[] b) throws IOException {
        int n = this.in.read(b);
        if (n == -1) {
            this.close();
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n == -1) {
            this.close();
        }
        return n;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

