/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.poller.PollerException;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.poller.PollerRequestResponsePair;

public class PollerRequestMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(PollerRequestMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        PollerRequestResponsePair pollerRequestResponsePair = (PollerRequestResponsePair)message.getPayload();
        PollerRequest pollerRequest = pollerRequestResponsePair.getPollerRequest();
        PollerResponse pollerResponse = pollerRequestResponsePair.getPollerResponse();
        String portletId = pollerRequest.getPortletId();
        PollerProcessor pollerProcessor = PollerProcessorUtil.getPollerProcessor(portletId);
        if (pollerRequest.isReceiveRequest()) {
            pollerResponse.createResponseMessage(message);
            try {
                try {
                    pollerProcessor.receive(pollerRequest, pollerResponse);
                }
                catch (PollerException pe) {
                    _log.error((Object)("Unable to receive poller request " + pollerRequest), (Throwable)pe);
                    pollerResponse.setParameter("pollerException", pe.getMessage());
                    pollerResponse.close();
                }
            }
            finally {
                pollerResponse.close();
            }
        } else {
            try {
                pollerProcessor.send(pollerRequest);
            }
            catch (PollerException pe) {
                _log.error((Object)("Unable to send poller request " + pollerRequest), (Throwable)pe);
            }
        }
    }
}

