/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.RequiredLayoutPrototypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutPrototypeLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutPrototypeLocalServiceImpl
extends LayoutPrototypeLocalServiceBaseImpl {
    public LayoutPrototype addLayoutPrototype(long userId, long companyId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        return this.addLayoutPrototype(userId, companyId, nameMap, description, active, new ServiceContext());
    }

    public LayoutPrototype addLayoutPrototype(long userId, long companyId, Map<Locale, String> nameMap, String description, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long layoutPrototypeId = this.counterLocalService.increment();
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.create(layoutPrototypeId);
        layoutPrototype.setUuid(serviceContext.getUuid());
        layoutPrototype.setCompanyId(companyId);
        layoutPrototype.setUserId(userId);
        layoutPrototype.setUserName(user.getFullName());
        layoutPrototype.setCreateDate(serviceContext.getCreateDate(now));
        layoutPrototype.setModifiedDate(serviceContext.getModifiedDate(now));
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescription(description);
        layoutPrototype.setActive(active);
        this.layoutPrototypePersistence.update((BaseModel)layoutPrototype);
        if (userId > 0L) {
            this.resourceLocalService.addResources(companyId, 0L, userId, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), false, false, false);
        }
        String friendlyURL = "/template-" + layoutPrototype.getLayoutPrototypeId();
        Group group = this.groupLocalService.addGroup(userId, 0L, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), 0L, layoutPrototype.getName(LocaleUtil.getDefault()), null, 0, true, 0, friendlyURL, false, true, null);
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("addDefaultLayout"), (boolean)true)) {
            this.layoutLocalService.addLayout(userId, group.getGroupId(), true, 0L, layoutPrototype.getName(LocaleUtil.getDefault()), null, null, "portlet", false, "/layout", serviceContext);
        }
        return layoutPrototype;
    }

    @Override
    @SystemEvent(action=1, type=1)
    public LayoutPrototype deleteLayoutPrototype(LayoutPrototype layoutPrototype) throws PortalException, SystemException {
        if (this.layoutPersistence.countByLayoutPrototypeUuid(layoutPrototype.getUuid()) > 0) {
            throw new RequiredLayoutPrototypeException();
        }
        Group group = layoutPrototype.getGroup();
        this.groupLocalService.deleteGroup(group);
        this.resourceLocalService.deleteResource(layoutPrototype.getCompanyId(), LayoutPrototype.class.getName(), 4, layoutPrototype.getLayoutPrototypeId());
        this.layoutPrototypePersistence.remove((BaseModel)layoutPrototype);
        PermissionCacheUtil.clearCache();
        return layoutPrototype;
    }

    @Override
    public LayoutPrototype deleteLayoutPrototype(long layoutPrototypeId) throws PortalException, SystemException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        return this.deleteLayoutPrototype(layoutPrototype);
    }

    public void deleteNondefaultLayoutPrototypes(long companyId) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        List layoutPrototypes = this.layoutPrototypePersistence.findByCompanyId(companyId);
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            if (layoutPrototype.getUserId() == defaultUserId) continue;
            this.deleteLayoutPrototype(layoutPrototype);
        }
    }

    public LayoutPrototype getLayoutPrototypeByUuid(String uuid) throws PortalException, SystemException {
        return this.layoutPrototypePersistence.findByUuid_First(uuid, null);
    }

    @Override
    public LayoutPrototype getLayoutPrototypeByUuidAndCompanyId(String uuid, long companyId) throws PortalException, SystemException {
        return this.layoutPrototypePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<LayoutPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator obc) throws SystemException {
        if (active != null) {
            return this.layoutPrototypePersistence.findByC_A(companyId, active.booleanValue(), start, end, obc);
        }
        return this.layoutPrototypePersistence.findByCompanyId(companyId, start, end, obc);
    }

    public int searchCount(long companyId, Boolean active) throws SystemException {
        if (active != null) {
            return this.layoutPrototypePersistence.countByC_A(companyId, active.booleanValue());
        }
        return this.layoutPrototypePersistence.countByCompanyId(companyId);
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        return this.updateLayoutPrototype(layoutPrototypeId, nameMap, description, active, null);
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, String description, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        layoutPrototype.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescription(description);
        layoutPrototype.setActive(active);
        this.layoutPrototypePersistence.update((BaseModel)layoutPrototype);
        Layout layout = layoutPrototype.getLayout();
        layout.setModifiedDate(layoutPrototype.getModifiedDate());
        layout.setNameMap(nameMap);
        this.layoutPersistence.update((BaseModel)layout);
        return layoutPrototype;
    }
}

