/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.typeconverter;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

public class NumberArrayConverter
implements TypeConverter<Number[]> {
    protected ConvertBean _convertBean;

    public NumberArrayConverter(ConvertBean convertBean) {
        this._convertBean = convertBean;
    }

    public Number[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray((String)value.toString());
                return this.convertArray(values);
            }
            return new Number[]{this._convertBean.toBigDecimal(value)};
        }
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive()) {
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                Number[] results = new Number[values.length];
                int i2 = 0;
                while (i2 < values.length) {
                    results[i2] = values[i2] ? 1 : 0;
                    ++i2;
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                Number[] results = new Number[values.length];
                int i3 = 0;
                while (i3 < values.length) {
                    results[i3] = values[i3];
                    ++i3;
                }
                return results;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                Number[] results = new Number[values.length];
                int i4 = 0;
                while (i4 < values.length) {
                    results[i4] = values[i4];
                    ++i4;
                }
                return results;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                Number[] results = new Number[values.length];
                int i5 = 0;
                while (i5 < values.length) {
                    results[i5] = Float.valueOf(values[i5]);
                    ++i5;
                }
                return results;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                Number[] results = new Number[values.length];
                int i6 = 0;
                while (i6 < values.length) {
                    results[i6] = values[i6];
                    ++i6;
                }
                return results;
            }
            if (type == long[].class) {
                long[] values = (long[])value;
                Number[] results = new Number[values.length];
                int i7 = 0;
                while (i7 < values.length) {
                    results[i7] = values[i7];
                    ++i7;
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                Number[] results = new Number[values.length];
                int i8 = 0;
                while (i8 < values.length) {
                    results[i8] = values[i8];
                    ++i8;
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected Number[] convertArray(Object[] values) {
        Number[] results = new Number[values.length];
        int i2 = 0;
        while (i2 < values.length) {
            results[i2] = this._convertBean.toBigDecimal(values[i2]);
            ++i2;
        }
        return results;
    }
}

