/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_1;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasFileEntry(long groupId, long folderId, String title) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select count(*) from DLFileEntry where groupId = ? and folderId = ? and title = ?");
            ps.setLong(1, groupId);
            ps.setLong(2, folderId);
            ps.setString(3, title);
            rs = ps.executeQuery();
            boolean bl = true;
            while (true) {
                int count;
                if (bl && !(bl = false)) {
                    if (true) break block5;
                }
                if ((count = rs.getInt(1)) <= 0) break block5;
                break;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        {
            block5: {
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return true;
            }
            if (rs.next()) continue;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return false;
    }

    protected void updateFileEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryId, groupId, folderId, title, extension, version from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String title = rs.getString("title");
                String extension = GetterUtil.getString((String)rs.getString("extension"));
                String version = rs.getString("version");
                String periodAndExtension = ".".concat(extension);
                if (!title.endsWith(periodAndExtension)) continue;
                String uniqueTitle = title = FileUtil.stripExtension((String)title);
                int count = 0;
                while (this.hasFileEntry(groupId, folderId, uniqueTitle) || count != 0 && this.hasFileEntry(groupId, folderId, String.valueOf(uniqueTitle) + periodAndExtension)) {
                    uniqueTitle = String.valueOf(title) + String.valueOf(++count);
                }
                if (count <= 0) continue;
                uniqueTitle = String.valueOf(uniqueTitle) + periodAndExtension;
                this.updateFileEntry(fileEntryId, version, uniqueTitle);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateFileEntry(long fileEntryId, String version, String newTitle) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DLFileEntry set title = ? where fileEntryId = ?");
            ps.setString(1, newTitle);
            ps.setLong(2, fileEntryId);
            ps.executeUpdate();
            DataAccess.cleanUp((Statement)ps);
            ps = con.prepareStatement("update DLFileVersion set title = ? where fileEntryId = ? and version = ?");
            ps.setString(1, newTitle);
            ps.setLong(2, fileEntryId);
            ps.setString(3, version);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

